/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class HeldCertificate {
    public final X509Certificate certificate;
    public final KeyPair keyPair;

    public HeldCertificate(X509Certificate certificate, KeyPair keyPair) {
        this.certificate = certificate;
        this.keyPair = keyPair;
    }

    public static final class Builder {
        private final long duration = 86400000L;
        private String hostname;
        private String serialNumber = "1";
        private KeyPair keyPair;
        private HeldCertificate issuedBy;
        private int maxIntermediateCas;

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder commonName(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public Builder issuedBy(HeldCertificate signedBy) {
            this.issuedBy = signedBy;
            return this;
        }

        public Builder ca(int maxIntermediateCas) {
            this.maxIntermediateCas = maxIntermediateCas;
            return this;
        }

        public HeldCertificate build() throws GeneralSecurityException {
            X500Principal signedByPrincipal;
            KeyPair signedByKeyPair;
            X500Principal subject;
            KeyPair heldKeyPair = this.keyPair != null ? this.keyPair : this.generateKeyPair();
            X500Principal x500Principal = subject = this.hostname != null ? new X500Principal("CN=" + this.hostname) : new X500Principal("CN=" + UUID.randomUUID());
            if (this.issuedBy != null) {
                signedByKeyPair = this.issuedBy.keyPair;
                signedByPrincipal = this.issuedBy.certificate.getSubjectX500Principal();
            } else {
                signedByKeyPair = heldKeyPair;
                signedByPrincipal = subject;
            }
            long now = System.currentTimeMillis();
            X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
            generator.setSerialNumber(new BigInteger(this.serialNumber));
            generator.setIssuerDN(signedByPrincipal);
            generator.setNotBefore(new Date(now));
            generator.setNotAfter(new Date(now + 86400000L));
            generator.setSubjectDN(subject);
            generator.setPublicKey(heldKeyPair.getPublic());
            generator.setSignatureAlgorithm("SHA256WithRSAEncryption");
            if (this.maxIntermediateCas > 0) {
                generator.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(this.maxIntermediateCas));
            }
            X509Certificate certificate = generator.generateX509Certificate(signedByKeyPair.getPrivate(), "BC");
            return new HeldCertificate(certificate, heldKeyPair);
        }

        public KeyPair generateKeyPair() throws GeneralSecurityException {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(1024, new SecureRandom());
            return keyPairGenerator.generateKeyPair();
        }

        static {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

