/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.service.keyvaluestorage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.agatha.service.keyvaluestorage.KeyValueStorageService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class KeyValueStorageMock
extends KeyValueStorageService {
    public final Map<String, String> storage = new HashMap<String, String>();

    public KeyValueStorageMock(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public Optional<String> get(String key) {
        if (this.storage.containsKey(key)) {
            return Optional.of(this.storage.get(key));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ReadableByteChannel> getAsReadableByteChannel(String key) {
        return Optional.empty();
    }

    @Override
    public void putJson(String key, String json) {
        this.storage.put(key, json);
    }

    @Override
    public Optional<WritableByteChannel> getWriter(final String key) {
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) throws UnsupportedEncodingException {
                StringBuilder strBuilder = new StringBuilder();
                String data = new String(src.array(), "UTF-8");
                if (KeyValueStorageMock.this.storage.containsKey(key) && this.isPartialData(data)) {
                    strBuilder.append(KeyValueStorageMock.this.storage.get(key));
                }
                strBuilder.append(data);
                KeyValueStorageMock.this.putJson(key, strBuilder.toString());
                return strBuilder.length();
            }

            private boolean isPartialData(String data) {
                try {
                    new ObjectMapper().readValue(data, (TypeReference)new TypeReference<Map<Object, Object>>(){});
                    return false;
                }
                catch (IOException e) {
                    return true;
                }
            }

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public void close() throws IOException {
            }
        };
        return Optional.of(channel);
    }

    @Override
    public Iterable<String> list(String prefix) {
        return this.storage.values();
    }

    @Override
    public void delete(String key) {
        this.storage.remove(key);
    }

    @Override
    public Map<String, String> getValues() {
        return this.storage;
    }

    @VisibleForTesting
    public boolean isKnown(String key) {
        return this.storage.containsKey(key);
    }

    @VisibleForTesting
    public void wipe() {
        this.storage.clear();
    }

    @Override
    public Iterable<String> list(String prefix, long limit) {
        return this.list(prefix);
    }
}

