/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class InputStreams {
    private static final InputStreams INSTANCE = new InputStreams();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static InputStreams instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    InputStreams() {
    }

    public void assertSameContentAs(AssertionInfo info, InputStream actual, InputStream expected) {
        Preconditions.checkNotNull(expected, "The InputStream to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of InputStreams:%n  <%s>%nand:%n  <%s>", actual, expected);
            throw new InputStreamsException(msg, e);
        }
    }

    private static void assertNotNull(AssertionInfo info, InputStream stream) {
        Objects.instance().assertNotNull(info, stream);
    }
}

