/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.powermock.configuration.GlobalConfiguration;
import org.powermock.configuration.PowerMockConfiguration;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.tests.utils.IgnorePackagesExtractor;

public class PowerMockIgnorePackagesExtractorImpl
implements IgnorePackagesExtractor {
    @Override
    public String[] getPackagesToIgnore(AnnotatedElement element) {
        PowerMockIgnore annotation = element.getAnnotation(PowerMockIgnore.class);
        boolean useGlobal = true;
        if (annotation != null) {
            useGlobal = annotation.globalIgnore();
        }
        HashSet<String> ignoredPackages = new HashSet<String>();
        String[] packageToIgnore = ignoredPackages.toArray(new String[ignoredPackages.size()]);
        if (useGlobal &= this.extractPackageToIgnore(element, ignoredPackages)) {
            return this.getPackageToIgnoreWithGlobal(packageToIgnore);
        }
        return packageToIgnore;
    }

    private String[] getPackageToIgnoreWithGlobal(String[] packageToIgnore) {
        String[] globalIgnore = this.getGlobalIgnore();
        String[] allPackageToIgnore = globalIgnore != null ? this.addGlobalIgnore(packageToIgnore, globalIgnore) : packageToIgnore;
        return allPackageToIgnore;
    }

    private String[] getGlobalIgnore() {
        PowerMockConfiguration powerMockConfiguration = GlobalConfiguration.powerMockConfiguration();
        return powerMockConfiguration.getGlobalIgnore();
    }

    private boolean extractPackageToIgnore(AnnotatedElement element, Set<String> ignoredPackages) {
        boolean useGlobalFromAnnotation = this.addValueFromAnnotation(element, ignoredPackages);
        boolean useGlobalFromSuperclass = this.addValuesFromSuperclass((Class)element, ignoredPackages);
        return useGlobalFromAnnotation & useGlobalFromSuperclass;
    }

    private boolean addValuesFromSuperclass(Class<?> element, Set<String> ignoredPackages) {
        ArrayList superclasses = new ArrayList();
        Collections.addAll(superclasses, element.getSuperclass());
        Collections.addAll(superclasses, element.getInterfaces());
        boolean useGlobalIgnore = true;
        for (Class superclass : superclasses) {
            if (superclass == null || superclass.equals(Object.class)) continue;
            useGlobalIgnore &= this.extractPackageToIgnore(superclass, ignoredPackages);
        }
        return useGlobalIgnore;
    }

    private boolean addValueFromAnnotation(AnnotatedElement element, Set<String> ignoredPackages) {
        PowerMockIgnore annotation = element.getAnnotation(PowerMockIgnore.class);
        if (annotation != null) {
            String[] ignores = annotation.value();
            Collections.addAll(ignoredPackages, ignores);
            return annotation.globalIgnore();
        }
        return true;
    }

    private String[] addGlobalIgnore(String[] packageToIgnore, String[] globalIgnore) {
        String[] allPackageToIgnore = new String[globalIgnore.length + packageToIgnore.length];
        System.arraycopy(globalIgnore, 0, allPackageToIgnore, 0, globalIgnore.length);
        System.arraycopy(packageToIgnore, 0, allPackageToIgnore, globalIgnore.length, packageToIgnore.length);
        return allPackageToIgnore;
    }
}

