/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.plugins.MockMaker;
import org.powermock.api.mockito.internal.invocation.MockitoMethodInvocationControl;
import org.powermock.api.mockito.internal.mockcreation.AbstractMockCreator;
import org.powermock.api.mockito.internal.mockcreation.MockitoStateCleaner;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.reflect.Whitebox;

public class DefaultMockCreator
extends AbstractMockCreator {
    private static final DefaultMockCreator MOCK_CREATOR = new DefaultMockCreator();

    public static <T> T mock(Class<T> type2, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        return MOCK_CREATOR.createMock(type2, isStatic, isSpy, delegator, mockSettings, methods);
    }

    @Override
    public <T> T createMock(Class<T> type2, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        if (type2 == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        this.validateType(type2, isStatic, isSpy);
        String mockName = this.toInstanceName(type2, mockSettings);
        MockRepository.addAfterMethodRunner(new MockitoStateCleanerRunnable());
        Class<Object> typeToMock = DefaultMockCreator.isFinalJavaSystemClass(type2) ? new ClassReplicaCreator().createClassReplica(type2) : type2;
        MockData<T> mockData = DefaultMockCreator.createMethodInvocationControl(mockName, typeToMock, methods, isSpy, delegator, mockSettings);
        T mock = mockData.getMock();
        if (DefaultMockCreator.isFinalJavaSystemClass(type2) && !isStatic) {
            mock = Whitebox.newInstance(type2);
            DefaultFieldValueGenerator.fillWithDefaultValues(mock);
        }
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl(type2, mockData.getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl(mock, mockData.getMethodInvocationControl());
        }
        if (isSpy) {
            new LenientCopyTool().copyToMock(delegator, mock);
        }
        return mock;
    }

    private static <T> boolean isFinalJavaSystemClass(Class<T> type2) {
        return type2.getName().startsWith("java.") && Modifier.isFinal(type2.getModifiers());
    }

    private static <T> MockData<T> createMethodInvocationControl(String mockName, Class<T> type2, Method[] methods, boolean isSpy, Object delegator, MockSettings mockSettings) {
        MockMaker mockMaker = DefaultMockCreator.getMockMaker();
        MockSettingsImpl settings = mockSettings == null ? (MockSettingsImpl)Mockito.withSettings() : (MockSettingsImpl)mockSettings;
        if (isSpy) {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        }
        settings.setMockName(new MockNameImpl(mockName));
        settings.setTypeToMock(type2);
        InternalMockHandler mockHandler = MockHandlerFactory.createMockHandler(settings);
        Object mock = mockMaker.createMock(settings, mockHandler);
        ClassLoader classLoader = mock.getClass().getClassLoader();
        if (classLoader instanceof MockClassLoader) {
            MockClassLoader mcl = (MockClassLoader)classLoader;
            mcl.cache(mock.getClass());
        }
        MockitoMethodInvocationControl invocationControl = new MockitoMethodInvocationControl(mockHandler, isSpy && delegator == null ? new Object() : delegator, mock, methods);
        return new MockData(invocationControl, mock);
    }

    private static MockMaker getMockMaker() {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DefaultMockCreator.class.getClassLoader());
        try {
            MockMaker mockMaker = Plugins.getMockMaker();
            return mockMaker;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private String toInstanceName(Class<?> clazz, MockSettings mockSettings) {
        String settingName;
        if (mockSettings instanceof MockSettingsImpl && (settingName = ((MockSettingsImpl)mockSettings).getName()) != null) {
            return settingName;
        }
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            return clazz.getName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    private static class MockitoStateCleanerRunnable
    implements Runnable {
        private MockitoStateCleanerRunnable() {
        }

        @Override
        public void run() {
            MockitoStateCleaner cleaner = new MockitoStateCleaner();
            cleaner.clearConfiguration();
            cleaner.clearMockProgress();
        }
    }

    private static class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        MockData(MockitoMethodInvocationControl methodInvocationControl, T mock) {
            this.methodInvocationControl = methodInvocationControl;
            this.mock = mock;
        }

        public MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public T getMock() {
            return this.mock;
        }
    }
}

