/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.internal.HeldCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class SslContextBuilder {
    private static SSLContext localhost;
    private HeldCertificate[] chain;
    private List<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();

    public static synchronized SSLContext localhost() {
        if (localhost != null) {
            return localhost;
        }
        try {
            HeldCertificate heldCertificate = new HeldCertificate.Builder().serialNumber("1").commonName(InetAddress.getByName("localhost").getHostName()).build();
            localhost = new SslContextBuilder().certificateChain(heldCertificate).addTrustedCertificate(heldCertificate.certificate).build();
            return localhost;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public SslContextBuilder certificateChain(HeldCertificate ... chain) {
        this.chain = chain;
        return this;
    }

    public SslContextBuilder addTrustedCertificate(X509Certificate certificate) {
        this.trustedCertificates.add(certificate);
        return this;
    }

    public SSLContext build() throws GeneralSecurityException {
        char[] password = "password".toCharArray();
        KeyStore keyStore = this.newEmptyKeyStore(password);
        if (this.chain != null) {
            Certificate[] certificates = new Certificate[this.chain.length];
            for (int i = 0; i < this.chain.length; ++i) {
                certificates[i] = this.chain[i].certificate;
            }
            keyStore.setKeyEntry("private", this.chain[0].keyPair.getPrivate(), password, certificates);
        }
        for (int i = 0; i < this.trustedCertificates.size(); ++i) {
            keyStore.setCertificateEntry("cert_" + i, this.trustedCertificates.get(i));
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

