/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeBlank;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualIgnoringCase;
import org.assertj.core.error.ShouldBeEqualIgnoringNewLineDifferences;
import org.assertj.core.error.ShouldBeEqualIgnoringWhitespace;
import org.assertj.core.error.ShouldBeEqualNormalizingWhitespace;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSubstring;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldContainCharSequenceOnlyOnce;
import org.assertj.core.error.ShouldContainCharSequenceSequence;
import org.assertj.core.error.ShouldContainOnlyDigits;
import org.assertj.core.error.ShouldContainPattern;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldMatchPattern;
import org.assertj.core.error.ShouldNotBeBlank;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotBeEqualIgnoringCase;
import org.assertj.core.error.ShouldNotBeEqualIgnoringWhitespace;
import org.assertj.core.error.ShouldNotBeEqualNormalizingWhitespace;
import org.assertj.core.error.ShouldNotContainCharSequence;
import org.assertj.core.error.ShouldNotContainPattern;
import org.assertj.core.error.ShouldNotEndWith;
import org.assertj.core.error.ShouldNotMatchPattern;
import org.assertj.core.error.ShouldNotStartWith;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.xml.XmlStringPrettyFormatter;

public class Strings {
    private static final Strings INSTANCE = new Strings();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Strings instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Strings() {
        this(StandardComparisonStrategy.instance());
    }

    public Strings(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertNullOrEmpty(AssertionInfo info, CharSequence actual) {
        if (actual != null && Strings.hasContent(actual)) {
            throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public void assertEmpty(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (Strings.hasContent(actual)) {
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public void assertNotEmpty(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (!Strings.hasContent(actual)) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    private static boolean hasContent(CharSequence s2) {
        return s2.length() > 0;
    }

    public void assertBlank(AssertionInfo info, CharSequence actual) {
        if (!this.isBlank(actual)) {
            throw this.failures.failure(info, ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public void assertNotBlank(AssertionInfo info, CharSequence actual) {
        if (this.isBlank(actual)) {
            throw this.failures.failure(info, ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    private boolean isBlank(CharSequence actual) {
        if (actual == null || actual.length() == 0) {
            return false;
        }
        for (int i = 0; i < actual.length(); ++i) {
            if (Whitespace.isWhitespace(actual.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void assertJavaBlank(AssertionInfo info, CharSequence actual) {
        if (!this.isJavaBlank(actual)) {
            throw this.failures.failure(info, ShouldBeBlank.shouldBeBlank(actual));
        }
    }

    public void assertNotJavaBlank(AssertionInfo info, CharSequence actual) {
        if (this.isJavaBlank(actual)) {
            throw this.failures.failure(info, ShouldNotBeBlank.shouldNotBeBlank(actual));
        }
    }

    private boolean isJavaBlank(CharSequence actual) {
        if (actual == null || actual.length() == 0) {
            return false;
        }
        for (int i = 0; i < actual.length(); ++i) {
            if (Character.isWhitespace(actual.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void assertHasSize(AssertionInfo info, CharSequence actual, int expectedSize) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, actual.length(), expectedSize, info);
    }

    public void assertHasLineCount(AssertionInfo info, CharSequence actual, int expectedLineCount) {
        this.assertNotNull(info, actual);
        LineNumberReader reader = new LineNumberReader(new StringReader(actual.toString()));
        try {
            while (reader.readLine() != null) {
            }
        }
        catch (IOException e) {
            throw new InputStreamsException(String.format("Unable to count lines in `%s`", actual), e);
        }
        CommonValidations.checkLineCounts(actual, reader.getLineNumber(), expectedLineCount, info);
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, Iterable<?> other) {
        this.assertNotNull(info, actual);
        CommonValidations.hasSameSizeAsCheck(info, (Object)actual, other, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, Object array) {
        Objects.instance().assertNotNull(info, actual);
        Arrays.assertIsArray(info, array);
        CommonValidations.hasSameSizeAsCheck(info, (Object)actual, array, actual.length());
    }

    public void assertHasSameSizeAs(AssertionInfo info, CharSequence actual, CharSequence other) {
        Objects.instance().assertNotNull(info, actual);
        CommonValidations.checkOtherIsNotNull(other, "CharSequence or String");
        CommonValidations.checkSameSizes(info, actual, actual.length(), other.length());
    }

    public void assertContains(AssertionInfo info, CharSequence actual, CharSequence ... values) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(values);
        this.checkIsNotEmpty(values);
        this.checkCharSequenceArrayDoesNotHaveNullElements(values);
        LinkedHashSet<CharSequence> notFound = new LinkedHashSet<CharSequence>();
        for (CharSequence value : values) {
            if (this.stringContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values[0], this.comparisonStrategy));
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    public void assertContainsOnlyDigits(AssertionInfo info, CharSequence actual) {
        this.assertNotNull(info, actual);
        if (actual.length() == 0) {
            throw this.failures.failure(info, ShouldContainOnlyDigits.shouldContainOnlyDigits(actual));
        }
        for (int index = 0; index < actual.length(); ++index) {
            char character = actual.charAt(index);
            if (Character.isDigit(character)) continue;
            throw this.failures.failure(info, ShouldContainOnlyDigits.shouldContainOnlyDigits(actual, character, index));
        }
    }

    private void checkIsNotNull(CharSequence ... values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private void checkIsNotEmpty(CharSequence ... values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private boolean stringContains(CharSequence actual, CharSequence sequence) {
        return this.comparisonStrategy.stringContains(actual.toString(), sequence.toString());
    }

    public void assertContainsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!actual.toString().toLowerCase().contains(sequence.toString().toLowerCase())) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContainIgnoringCase(actual, sequence));
        }
    }

    public void assertDoesNotContain(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (this.stringContains(actual, sequence)) {
            throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, sequence, this.comparisonStrategy));
        }
    }

    private void checkCharSequenceIsNotNull(CharSequence sequence) {
        Preconditions.checkNotNull(sequence, "The char sequence to look for should not be null");
    }

    public void assertEqualsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (!this.areEqualIgnoringCase(actual, expected)) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringCase.shouldBeEqual(actual, expected));
        }
    }

    public void assertNotEqualsIgnoringCase(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringCase(actual, expected)) {
            throw this.failures.failure(info, ShouldNotBeEqualIgnoringCase.shouldNotBeEqualIgnoringCase(actual, expected));
        }
    }

    private boolean areEqualIgnoringCase(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        return actual.toString().equalsIgnoreCase(expected.toString());
    }

    public void assertIsEqualToNormalizingNewlines(AssertionInfo info, CharSequence actual, CharSequence expected) {
        String expectedNormalized;
        String actualNormalized = Strings.normalizeNewlines(actual);
        if (!actualNormalized.equals(expectedNormalized = Strings.normalizeNewlines(expected))) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringNewLineDifferences.shouldBeEqualIgnoringNewLineDifferences(actual, expected));
        }
    }

    private static String normalizeNewlines(CharSequence actual) {
        return actual.toString().replace("\r\n", "\n");
    }

    public void assertEqualsIgnoringWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (!this.areEqualIgnoringWhitespace(actual, expected)) {
            throw this.failures.failure(info, ShouldBeEqualIgnoringWhitespace.shouldBeEqualIgnoringWhitespace(actual, expected));
        }
    }

    public void assertNotEqualsIgnoringWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (this.areEqualIgnoringWhitespace(actual, expected)) {
            throw this.failures.failure(info, ShouldNotBeEqualIgnoringWhitespace.shouldNotBeEqualIgnoringWhitespace(actual, expected));
        }
    }

    private boolean areEqualIgnoringWhitespace(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        this.checkCharSequenceIsNotNull(expected);
        return this.removeAllWhitespaces(actual).equals(this.removeAllWhitespaces(expected));
    }

    private String removeAllWhitespaces(CharSequence toBeStripped) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < toBeStripped.length(); ++i) {
            char c = toBeStripped.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString().trim();
    }

    public void assertEqualsNormalizingWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (!this.areEqualNormalizingWhitespace(actual, expected)) {
            throw this.failures.failure(info, ShouldBeEqualNormalizingWhitespace.shouldBeEqualNormalizingWhitespace(actual, expected));
        }
    }

    public void assertNotEqualsNormalizingWhitespace(AssertionInfo info, CharSequence actual, CharSequence expected) {
        if (this.areEqualNormalizingWhitespace(actual, expected)) {
            throw this.failures.failure(info, ShouldNotBeEqualNormalizingWhitespace.shouldNotBeEqualNormalizingWhitespace(actual, expected));
        }
    }

    private boolean areEqualNormalizingWhitespace(CharSequence actual, CharSequence expected) {
        if (actual == null) {
            return expected == null;
        }
        this.checkCharSequenceIsNotNull(expected);
        return this.normalizeWhitespace(actual).equals(this.normalizeWhitespace(expected));
    }

    private String normalizeWhitespace(CharSequence toNormalize) {
        StringBuilder result = new StringBuilder();
        boolean lastWasSpace = true;
        for (int i = 0; i < toNormalize.length(); ++i) {
            char c = toNormalize.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!lastWasSpace) {
                    result.append(' ');
                }
                lastWasSpace = true;
                continue;
            }
            result.append(c);
            lastWasSpace = false;
        }
        return result.toString().trim();
    }

    public void assertContainsOnlyOnce(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.checkCharSequenceIsNotNull(sequence);
        this.assertNotNull(info, actual);
        int sequenceOccurrencesInActual = this.countOccurrences(sequence, actual);
        if (sequenceOccurrencesInActual == 1) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequenceOnlyOnce.shouldContainOnlyOnce(actual, sequence, sequenceOccurrencesInActual, this.comparisonStrategy));
    }

    private int countOccurrences(CharSequence sequenceToSearch, CharSequence actual) {
        String strToSearch = sequenceToSearch.toString();
        String strActual = actual.toString();
        int occurrences = 0;
        for (int i = 0; i <= strActual.length() - strToSearch.length(); ++i) {
            if (!this.comparisonStrategy.areEqual(strActual.substring(i, i + sequenceToSearch.length()), strToSearch)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public void assertStartsWith(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info, actual);
        if (!this.comparisonStrategy.stringStartsWith(actual.toString(), prefix.toString())) {
            throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual, prefix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotStartWith(AssertionInfo info, CharSequence actual, CharSequence prefix) {
        Strings.failIfPrefixIsNull(prefix);
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy.stringStartsWith(actual.toString(), prefix.toString())) {
            throw this.failures.failure(info, ShouldNotStartWith.shouldNotStartWith(actual, prefix, this.comparisonStrategy));
        }
    }

    private static void failIfPrefixIsNull(CharSequence prefix) {
        Preconditions.checkNotNull(prefix, "The given prefix should not be null");
    }

    public void assertEndsWith(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info, actual);
        if (!this.comparisonStrategy.stringEndsWith(actual.toString(), suffix.toString())) {
            throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual, suffix, this.comparisonStrategy));
        }
    }

    public void assertDoesNotEndWith(AssertionInfo info, CharSequence actual, CharSequence suffix) {
        Strings.failIfSuffixIsNull(suffix);
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy.stringEndsWith(actual.toString(), suffix.toString())) {
            throw this.failures.failure(info, ShouldNotEndWith.shouldNotEndWith(actual, suffix, this.comparisonStrategy));
        }
    }

    private static void failIfSuffixIsNull(CharSequence suffix) {
        Preconditions.checkNotNull(suffix, "The given suffix should not be null");
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (!Pattern.matches(regex.toString(), actual)) {
            throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, regex));
        }
    }

    public void assertDoesNotMatch(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        if (Pattern.matches(regex.toString(), actual)) {
            throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, regex));
        }
    }

    private void checkRegexIsNotNull(CharSequence regex) {
        if (regex == null) {
            throw this.patternToMatchIsNull();
        }
    }

    public void assertMatches(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        if (!pattern.matcher(actual).matches()) {
            throw this.failures.failure(info, ShouldMatchPattern.shouldMatch(actual, pattern.pattern()));
        }
    }

    public void assertDoesNotMatch(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        if (actual != null && pattern.matcher(actual).matches()) {
            throw this.failures.failure(info, ShouldNotMatchPattern.shouldNotMatch(actual, pattern.pattern()));
        }
    }

    private void checkIsNotNull(Pattern pattern) {
        if (pattern == null) {
            throw this.patternToMatchIsNull();
        }
    }

    private NullPointerException patternToMatchIsNull() {
        return new NullPointerException("The regular expression pattern to match should not be null");
    }

    private void assertNotNull(AssertionInfo info, CharSequence actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public void assertContainsSequence(AssertionInfo info, CharSequence actual, CharSequence[] sequence) {
        this.assertNotNull(info, actual);
        this.checkIsNotNull(sequence);
        this.checkIsNotEmpty(sequence);
        this.checkCharSequenceArrayDoesNotHaveNullElements(sequence);
        LinkedHashSet<CharSequence> notFound = new LinkedHashSet<CharSequence>();
        for (CharSequence value : sequence) {
            if (this.stringContains(actual, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            if (notFound.size() == 1 && sequence.length == 1) {
                throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, sequence[0], this.comparisonStrategy));
            }
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, sequence, notFound, this.comparisonStrategy));
        }
        if (sequence.length == 1) {
            return;
        }
        String strActual = actual.toString();
        for (int i = 1; i < sequence.length; ++i) {
            int indexOfNextSequenceValue;
            int indexOfCurrentSequenceValue = this.indexOf(strActual, sequence[i - 1].toString());
            if (indexOfCurrentSequenceValue > (indexOfNextSequenceValue = this.indexOf(strActual, sequence[i].toString()))) {
                throw this.failures.failure(info, ShouldContainCharSequenceSequence.shouldContainSequence(actual, sequence, i - 1, this.comparisonStrategy));
            }
            strActual = strActual.substring(indexOfCurrentSequenceValue + 1);
        }
    }

    private int indexOf(String string, String toFind) {
        for (int i = 0; i < string.length(); ++i) {
            if (!this.comparisonStrategy.stringStartsWith(string.substring(i), toFind)) continue;
            return i;
        }
        return -1;
    }

    public void assertXmlEqualsTo(AssertionInfo info, CharSequence actualXml, CharSequence expectedXml) {
        this.checkCharSequenceIsNotNull(expectedXml);
        this.assertNotNull(info, actualXml);
        String formattedActualXml = XmlStringPrettyFormatter.xmlPrettyFormat(actualXml.toString());
        String formattedExpectedXml = XmlStringPrettyFormatter.xmlPrettyFormat(expectedXml.toString());
        if (!this.comparisonStrategy.areEqual(formattedActualXml, formattedExpectedXml)) {
            throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(formattedActualXml, formattedExpectedXml, this.comparisonStrategy, info.representation()));
        }
    }

    public void assertIsSubstringOf(AssertionInfo info, CharSequence actual, CharSequence sequence) {
        this.assertNotNull(info, actual);
        Preconditions.checkNotNull(sequence, "Expecting CharSequence not to be null");
        if (this.stringContains(sequence.toString(), actual.toString())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeSubstring.shouldBeSubstring(actual, sequence, this.comparisonStrategy));
    }

    public void assertContainsPattern(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        this.assertNotNull(info, actual);
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            throw this.failures.failure(info, ShouldContainPattern.shouldContainPattern(actual, pattern.pattern()));
        }
    }

    public void assertContainsPattern(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        Matcher matcher = pattern.matcher(actual);
        if (!matcher.find()) {
            throw this.failures.failure(info, ShouldContainPattern.shouldContainPattern(actual, pattern.pattern()));
        }
    }

    public void assertDoesNotContainPattern(AssertionInfo info, CharSequence actual, CharSequence regex) {
        this.checkRegexIsNotNull(regex);
        Pattern pattern = Pattern.compile(regex.toString());
        this.assertDoesNotContainPattern(info, actual, pattern);
    }

    public void assertDoesNotContainPattern(AssertionInfo info, CharSequence actual, Pattern pattern) {
        this.checkIsNotNull(pattern);
        this.assertNotNull(info, actual);
        Matcher matcher = pattern.matcher(actual);
        if (matcher.find()) {
            throw this.failures.failure(info, ShouldNotContainPattern.shouldNotContainPattern(actual, pattern.pattern()));
        }
    }

    private void checkCharSequenceArrayDoesNotHaveNullElements(CharSequence[] values) {
        if (values.length == 1) {
            this.checkCharSequenceIsNotNull(values[0]);
        } else {
            for (int i = 0; i < values.length; ++i) {
                Preconditions.checkNotNull(values[i], "Expecting CharSequence elements not to be null but found one at index " + i);
            }
        }
    }

    private static final class Whitespace {
        private static final String TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
        private static final int MULTIPLIER = 1682554634;
        private static final int SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);

        private Whitespace() {
        }

        public static boolean isWhitespace(char c) {
            return TABLE.charAt(1682554634 * c >>> SHIFT) == c;
        }
    }
}

