/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Constructor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.core.spi.support.InvocationSubstitute;

public class DelegatingToConstructorsOngoingStubbing<T>
implements OngoingStubbing<T> {
    private final OngoingStubbing<T> stubbing;
    private final Constructor<?>[] ctors;

    public DelegatingToConstructorsOngoingStubbing(Constructor<?>[] ctors, OngoingStubbing<T> stubbing) {
        if (stubbing == null) {
            throw new IllegalArgumentException("Internal error: Ongoing stubbing must be provided");
        }
        this.ctors = ctors;
        this.stubbing = stubbing;
    }

    @Override
    public OngoingStubbing<T> thenReturn(final T value) {
        this.stubbing.thenReturn(value);
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.thenReturn(value);
            }
        }.invoke();
    }

    @Override
    public OngoingStubbing<T> thenReturn(final T value, final T ... values) {
        this.stubbing.thenReturn(value, values);
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.thenReturn(value, values);
            }
        }.invoke();
    }

    @Override
    public OngoingStubbing<T> thenThrow(final Throwable ... throwables) {
        this.stubbing.thenThrow(throwables);
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.thenThrow(throwables);
            }
        }.invoke();
    }

    public OngoingStubbing<T> thenThrow(final Class<? extends Throwable> ... throwableClasses) {
        this.stubbing.thenThrow(throwableClasses);
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.thenThrow(throwableClasses);
            }
        }.invoke();
    }

    @Override
    public OngoingStubbing<T> thenCallRealMethod() {
        this.stubbing.thenCallRealMethod();
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.thenCallRealMethod();
            }
        }.invoke();
    }

    @Override
    public OngoingStubbing<T> thenAnswer(final Answer<?> answer) {
        this.stubbing.thenAnswer(answer);
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.thenAnswer(answer);
            }
        }.invoke();
    }

    @Override
    public OngoingStubbing<T> then(final Answer<?> answer) {
        this.stubbing.then(answer);
        return new InvokeStubMethod(){

            @Override
            public void performStubbing(OngoingStubbing<T> when) {
                when.then(answer);
            }
        }.invoke();
    }

    @Override
    public <M> M getMock() {
        return this.stubbing.getMock();
    }

    private abstract class InvokeStubMethod {
        private InvokeStubMethod() {
        }

        public OngoingStubbing<T> invoke() {
            InvocationSubstitute mock = (InvocationSubstitute)DelegatingToConstructorsOngoingStubbing.this.stubbing.getMock();
            for (Constructor constructor : DelegatingToConstructorsOngoingStubbing.this.ctors) {
                Class<?>[] parameterTypesForCtor = constructor.getParameterTypes();
                Object[] paramArgs = new Object[parameterTypesForCtor.length];
                for (int i = 0; i < parameterTypesForCtor.length; ++i) {
                    Class<?> paramType = parameterTypesForCtor[i];
                    paramArgs[i] = Matchers.any(paramType);
                }
                try {
                    OngoingStubbing when = Mockito.when(mock.performSubstitutionLogic(paramArgs));
                    this.performStubbing(when);
                }
                catch (Exception e) {
                    throw new RuntimeException("PowerMock internal error", e);
                }
            }
            return DelegatingToConstructorsOngoingStubbing.this.stubbing;
        }

        public abstract void performStubbing(OngoingStubbing<T> var1);
    }
}

