/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.api;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.http.javadsl.ClientTransport;
import akka.http.javadsl.Http;
import akka.http.javadsl.HttpsConnectionContext;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.headers.BasicHttpCredentials;
import akka.http.javadsl.model.headers.HttpCredentials;
import akka.http.javadsl.settings.ConnectionPoolSettings;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.util.ByteString;
import com.typesafe.sslconfig.akka.AkkaSSLConfig;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.PassiveTrustManager;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestionHttpClient {
    private static Logger logger = LoggerFactory.getLogger(IngestionHttpClient.class);
    static String HTTP_PROXY_ENV = "http_proxy";
    static String HTTPS_PROXY_ENV = "https_proxy";
    private static ActorSystem actorSystem = ActorSystem.create((String)"httpClientSystem");
    private static Materializer materializer = ActorMaterializer.create((ActorRefFactory)actorSystem);
    private static HttpsConnectionContext httpsConnectionContext = IngestionHttpClient.httpsConnectionContext(actorSystem);
    private static BasicHttpCredentials httpCredentials = HttpCredentials.createBasicHttpCredentials((String)AgathaConfiguration.getDefaultApiUsername(), (String)AgathaConfiguration.getDefaultApiPassword());
    private static ConnectionPoolSettings connectionPoolSettings = IngestionHttpClient.getConnectionPoolSettings(actorSystem);

    public ByteString syncRequest(HttpRequest httpRequest) {
        try {
            return this.request(httpRequest).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Execution interrupted", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Execution exception", e);
        }
    }

    public HttpResponse syncRequestReturnsResponse(HttpRequest httpRequest) {
        try {
            return this.requestReturnsResponse(httpRequest).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Execution interrupted", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Execution exception", e);
        }
    }

    public CompletionStage<HttpResponse> requestReturnsResponse(HttpRequest request) {
        return this.createRequest(request);
    }

    public CompletionStage<ByteString> request(HttpRequest request) {
        return this.createRequest(request).thenCompose(response -> response.entity().getDataBytes().runFold((Object)ByteString.empty(), ByteString::concat, materializer));
    }

    private CompletionStage<HttpResponse> createRequest(HttpRequest request) {
        return Http.get((ActorSystem)actorSystem).singleRequest((HttpRequest)request.addCredentials((HttpCredentials)httpCredentials), httpsConnectionContext, connectionPoolSettings, actorSystem.log());
    }

    private static Optional<String> getSafeEnv(String env) {
        try {
            Optional<String> s = Optional.ofNullable(System.getenv(env));
            if (!s.isPresent()) {
                logger.info("No environment variable [{}] defined", (Object)env);
            }
            return s;
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    static ConnectionPoolSettings getConnectionPoolSettings(ActorSystem actorSystem) {
        Optional<String> proxyConnection = IngestionHttpClient.getSafeEnv(HTTP_PROXY_ENV);
        proxyConnection = IngestionHttpClient.getSafeEnv(HTTPS_PROXY_ENV).isPresent() ? IngestionHttpClient.getSafeEnv(HTTPS_PROXY_ENV) : proxyConnection;
        return proxyConnection.filter(p -> !p.trim().isEmpty()).map(httpProxy -> {
            try {
                logger.info("HTTP proxy is going to be used = {}", httpProxy);
                URL url = new URL((String)httpProxy);
                ClientTransport ct = Optional.ofNullable(url.getUserInfo()).filter(String::isEmpty).flatMap(IngestionHttpClient::extractCredentials).map(cr -> ClientTransport.httpsProxy((InetSocketAddress)InetSocketAddress.createUnresolved(url.getHost(), url.getPort()), (HttpCredentials)cr)).orElse(ClientTransport.httpsProxy((InetSocketAddress)InetSocketAddress.createUnresolved(url.getHost(), url.getPort())));
                return ConnectionPoolSettings.create((ActorSystem)actorSystem).withMaxOpenRequests(64).withMaxConnections(64).withTransport(ct);
            }
            catch (Exception e) {
                logger.error("Proxy syntax error format should be like 'http(s)://example.com:3128' message: {}", (Object)e.getMessage());
                return null;
            }
        }).orElse(ConnectionPoolSettings.create((ActorSystem)actorSystem).withMaxOpenRequests(64).withMaxConnections(64));
    }

    private static Optional<HttpCredentials> extractCredentials(String str) {
        String[] split = str.split(":");
        if (split.length == 2) {
            logger.info("Basic auth for the HTTP(s) proxy, username = {}, password = ***", (Object)split[0]);
            return Optional.of(HttpCredentials.createBasicHttpCredentials((String)split[0], (String)split[1]));
        }
        return Optional.empty();
    }

    private static HttpsConnectionContext httpsConnectionContext(ActorSystem system) {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLSv1.2");
            PassiveTrustManager trustManager = new PassiveTrustManager();
            context.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        AkkaSSLConfig defaultSSLConfig = AkkaSSLConfig.get((ActorSystem)system);
        AkkaSSLConfig badSslConfig = defaultSSLConfig.convertSettings(s -> s.withLoose(s.loose().withDisableSNI(true).withDisableHostnameVerification(true)));
        akka.http.scaladsl.HttpsConnectionContext httpsConnectionContext = HttpsConnectionContext.https((SSLContext)context, Optional.of(badSslConfig), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        return httpsConnectionContext;
    }

    public static String ingestionUrl(String url) {
        return "https://" + AgathaConfiguration.getIngestionRestHost() + ":" + AgathaConfiguration.getIngestionRestPort() + url;
    }

    public static void shutdown() {
        if (actorSystem != null) {
            actorSystem.terminate();
        }
    }
}

