/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.java;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.twitter.chill.java.ArraysAsListSerializer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestLists {
    private static final Kryo kryo = new Kryo();
    private static final Map<Class<?>, List<?>> map = new HashMap(9);

    public static <T> T serializeAndDeserialize(T t) throws ClassNotFoundException {
        Output output = new Output(1000, -1);
        kryo.register(Class.forName("java.util.List"));
        kryo.writeClassAndObject(output, t);
        Input input = new Input(output.toBytes());
        return (T)kryo.readClassAndObject(input);
    }

    public static List<?> getList(Class<?> clazz) {
        return map.get(clazz);
    }

    static {
        ArraysAsListSerializer.registrar().apply(kryo);
        map.put(Byte.TYPE, Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4));
        map.put(Short.TYPE, Arrays.asList((short)1, (short)2, (short)3, (short)4));
        map.put(Integer.TYPE, Arrays.asList(1, 2, 3, 4));
        map.put(Long.TYPE, Arrays.asList(1L, 2L, 3L, 4L));
        map.put(Character.TYPE, Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4')));
        map.put(Float.TYPE, Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)));
        map.put(Double.TYPE, Arrays.asList(1.0, 2.0, 3.0, 4.0));
        map.put(Boolean.TYPE, Arrays.asList(true, false, true));
        map.put(String.class, Arrays.asList("one", "two", "three"));
        map.put(List.class, Arrays.asList(Arrays.asList(1, 2, 3, 4), Arrays.asList(1.0, 2.0, 3.0, 4.0), Arrays.asList("one", "two", "three")));
    }
}

