/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigUtil;
import com.typesafe.config.ConfigValue;
import com.xebialabs.overcast.PropertiesLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvercastProperties {
    public static final String PASSWORD_PROPERTY_SUFFIX = ".password";
    private static Logger logger = LoggerFactory.getLogger(OvercastProperties.class);
    private static Config overcastProperties;

    private static Config getOvercastConfig() {
        if (overcastProperties == null) {
            overcastProperties = PropertiesLoader.loadOvercastConfig();
        }
        return overcastProperties;
    }

    public static void reloadOvercastProperties() {
        ConfigFactory.invalidateCaches();
        overcastProperties = null;
    }

    public static Set<String> getOvercastPropertyNames(String path) {
        HashSet names = Sets.newHashSet();
        Config overcastConfig = OvercastProperties.getOvercastConfig();
        if (!overcastConfig.hasPath(path)) {
            return names;
        }
        Config cfg = overcastConfig.getConfig(path);
        Collection tmp = Collections2.transform((Collection)cfg.entrySet(), (Function)new Function<Map.Entry<String, ConfigValue>, String>(){

            public String apply(Map.Entry<String, ConfigValue> mapping) {
                String key = mapping.getKey();
                return (String)ConfigUtil.splitPath((String)key).get(0);
            }
        });
        names.addAll(tmp);
        return names;
    }

    public static String getOvercastProperty(String key) {
        return OvercastProperties.getOvercastProperty(key, null);
    }

    public static String getOvercastProperty(String key, String defaultValue) {
        Config overcastConfig = OvercastProperties.getOvercastConfig();
        String value = overcastConfig.hasPath(key) ? overcastConfig.getString(key) : defaultValue;
        if (logger.isTraceEnabled()) {
            if (value == null) {
                logger.trace("Overcast property {} is null", (Object)key);
            } else {
                logger.trace("Overcast property {}={}", (Object)key, (Object)(key.endsWith(PASSWORD_PROPERTY_SUFFIX) ? "********" : value));
            }
        }
        return value;
    }

    public static boolean getOvercastBooleanProperty(String key) {
        return OvercastProperties.getOvercastBooleanProperty(key, false);
    }

    public static boolean getOvercastBooleanProperty(String key, boolean defaultValue) {
        Config overcastConfig = OvercastProperties.getOvercastConfig();
        boolean value = overcastConfig.hasPath(key) ? overcastConfig.getBoolean(key) : defaultValue;
        if (logger.isTraceEnabled()) {
            logger.trace("Overcast property {}={}", (Object)key, key.endsWith(PASSWORD_PROPERTY_SUFFIX) ? "********" : Boolean.valueOf(value));
        }
        return value;
    }

    public static List<String> getOvercastListProperty(String key) {
        return OvercastProperties.getOvercastListProperty(key, Lists.newArrayList());
    }

    public static List<String> getOvercastListProperty(String key, List<String> defaultValue) {
        Config overcastConfig = OvercastProperties.getOvercastConfig();
        List value = overcastConfig.hasPath(key) ? overcastConfig.getStringList(key) : defaultValue;
        if (logger.isTraceEnabled()) {
            if (value == null) {
                logger.trace("Overcast property {} is null", (Object)key);
            } else {
                logger.trace("Overcast property {}={}", (Object)key, key.endsWith(PASSWORD_PROPERTY_SUFFIX) ? "********" : value);
            }
        }
        return value;
    }

    public static String getRequiredOvercastProperty(String key) {
        String value = OvercastProperties.getOvercastProperty(key);
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"Required property %s is not specified as a system property or in overcast.conf which can be placed in the current working directory, in ~/.overcast or on the classpath", (Object[])new Object[]{key});
        return value;
    }

    public static Map<Integer, Integer> parsePortsProperty(String ports) {
        LinkedHashMap portForwardMap = Maps.newLinkedHashMap();
        StringTokenizer toker = new StringTokenizer(ports, ",");
        while (toker.hasMoreTokens()) {
            String[] localAndRemotePort = toker.nextToken().split(":");
            Preconditions.checkArgument((localAndRemotePort.length == 2 ? 1 : 0) != 0, (String)"Property value \"%s\" does not have the right format, e.g. 2222:22,1445:445", (Object[])new Object[]{ports});
            try {
                int localPort = Integer.parseInt(localAndRemotePort[0]);
                int remotePort = Integer.parseInt(localAndRemotePort[1]);
                portForwardMap.put(remotePort, localPort);
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException("Property value \"" + ports + "\" does not have the right format, e.g. 2222:22,1445:445", exc);
            }
        }
        return portForwardMap;
    }
}

