/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public final class OverthereUtil {
    private OverthereUtil() {
    }

    public static ConnectionOptions fromQuery(URI url) {
        ConnectionOptions options = new ConnectionOptions();
        options.set("address", (Object)url.getHost());
        if (url.getPort() > 0) {
            options.set("port", (Object)url.getPort());
        }
        String user = url.getUserInfo();
        String password = null;
        if (user == null) {
            user = System.getProperty("user.name");
        } else {
            int idx = user.indexOf(58);
            if (idx != -1) {
                password = user.substring(idx + 1);
                options.set("password", (Object)password);
                user = user.substring(0, idx);
            }
        }
        options.set("username", (Object)user);
        List nvps = URLEncodedUtils.parse((URI)url, (String)"UTF-8");
        for (NameValuePair nvp : nvps) {
            options.set(nvp.getName(), (Object)nvp.getValue());
        }
        return options;
    }

    public static OverthereConnection overthereConnectionFromURI(String url) {
        try {
            return OverthereUtil.overthereConnectionFromURI(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static OverthereConnection overthereConnectionFromURI(URI url) {
        ConnectionOptions options = OverthereUtil.fromQuery(url);
        OverthereConnection connection = Overthere.getConnection((String)url.getScheme(), (ConnectionOptions)options);
        return connection;
    }

    public static void copyFiles(OverthereConnection srcHost, OverthereConnection dstHost, List<String> copySpec) {
        if (copySpec.isEmpty()) {
            return;
        }
        if (copySpec.size() % 2 == 0) {
            Iterator<String> toCopy = copySpec.iterator();
            while (toCopy.hasNext()) {
                OverthereFile src = srcHost.getFile(toCopy.next());
                OverthereFile dst = dstHost.getFile(toCopy.next());
                src.copyTo(dst);
            }
        } else {
            List<String> srcFiles = copySpec.subList(0, copySpec.size() - 1);
            OverthereFile dst = dstHost.getFile(copySpec.get(copySpec.size() - 1));
            Iterator<String> toCopy = srcFiles.iterator();
            while (toCopy.hasNext()) {
                OverthereFile src = srcHost.getFile(toCopy.next());
                src.copyTo(dst);
            }
        }
    }
}

