/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast;

import com.google.common.io.Resources;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    public static final String OVERCAST_CONF_FILE = "overcast.conf";
    public static final String OVERCAST_USER_DIR = ".overcast";
    public static final String OVERCAST_CONF_FILE_PROPERTY = "overcast.conf.file";

    private static String getUserOvercastConfPath() {
        return new File(new File(System.getProperty("user.home"), OVERCAST_USER_DIR), OVERCAST_CONF_FILE).getAbsolutePath();
    }

    public static Config loadOvercastConfig() {
        return ConfigFactory.systemProperties().withFallback((ConfigMergeable)PropertiesLoader.loadOvercastConfigFromFile(PropertiesLoader.getUserOvercastConfPath())).withFallback((ConfigMergeable)PropertiesLoader.loadOvercastConfigFromFile(OVERCAST_CONF_FILE)).withFallback((ConfigMergeable)PropertiesLoader.loadOvercastConfigFromFile(System.getProperty(OVERCAST_CONF_FILE_PROPERTY))).withFallback((ConfigMergeable)PropertiesLoader.loadOvercastConfigFromClasspath(OVERCAST_CONF_FILE)).resolve();
    }

    static Config loadOvercastConfigFromClasspath(String path) {
        try {
            return PropertiesLoader.loadOvercastConfigFromFile(Resources.getResource((String)path).toURI().getPath());
        }
        catch (IllegalArgumentException e) {
            logger.warn("File '{}' not found on classpath.", (Object)path);
        }
        catch (URISyntaxException e) {
            logger.warn("File '{}' not found on classpath.", (Object)path);
        }
        return ConfigFactory.empty();
    }

    static Config loadOvercastConfigFromFile(String file) {
        if (file == null) {
            return ConfigFactory.empty();
        }
        File f = new File(file);
        if (!f.exists()) {
            logger.warn("File {} not found.", (Object)f.getAbsolutePath());
            return ConfigFactory.empty();
        }
        logger.info("Loading from file {}", (Object)f.getAbsolutePath());
        return ConfigFactory.parseFile((File)f);
    }
}

