/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.command;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Command {
    private List<String> command = new ArrayList<String>();

    private Command() {
    }

    public static Command aCommand(String executable) {
        if (executable == null) {
            throw new IllegalArgumentException("Executable can not be null");
        }
        Command c = new Command();
        c.withPart(executable);
        return c;
    }

    public Command withPart(String ... part) {
        if (part == null) {
            return this;
        }
        this.command.addAll(Collections2.filter(Arrays.asList(part), (Predicate)Predicates.notNull()));
        return this;
    }

    public Command withArguments(String ... argument) {
        return this.withPart(argument);
    }

    public Command withOptions(String ... option) {
        return this.withPart(option);
    }

    public Command withPrefix(String prefix) {
        return this.withPart(prefix);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String toString() {
        return Joiner.on((String)" ").join(this.command);
    }

    public static Command fromString(String s) {
        Command c = new Command();
        for (String o : Splitter.on((String)" ").split((CharSequence)s)) {
            c.getCommand().add(o);
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Command)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        int c = 1000;
        for (char ch : this.toString().toCharArray()) {
            c += ch;
        }
        return c;
    }

    public List<String> asList() {
        return Arrays.asList(this.getCommand().toArray(new String[this.getCommand().size()]));
    }
}

