/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.command;

import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandResponse;
import com.xebialabs.overcast.command.NonZeroCodeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.input.TeeInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandProcessor {
    public static Logger logger = LoggerFactory.getLogger(CommandProcessor.class);
    private String execDir = ".";

    private CommandProcessor(String execDir) {
        this.execDir = execDir;
    }

    private CommandProcessor() {
    }

    public static CommandProcessor atLocation(String l) {
        return new CommandProcessor(l);
    }

    public static CommandProcessor atCurrentDir() {
        return new CommandProcessor();
    }

    public CommandResponse run(Command command) {
        logger.debug("Executing command {}", (Object)command);
        try {
            Process p = new ProcessBuilder(command.asList()).directory(new File(this.execDir)).start();
            ByteArrayOutputStream errors = new ByteArrayOutputStream();
            ByteArrayOutputStream messages = new ByteArrayOutputStream();
            Thread t1 = this.showProcessOutput((InputStream)new TeeInputStream(p.getErrorStream(), (OutputStream)errors), System.err);
            Thread t2 = this.showProcessOutput((InputStream)new TeeInputStream(p.getInputStream(), (OutputStream)messages), System.out);
            int code = p.waitFor();
            t1.join();
            t2.join();
            CommandResponse response = new CommandResponse(code, errors.toString(), messages.toString());
            if (!response.isSuccessful()) {
                throw new NonZeroCodeException(command, response);
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Cannot execute " + command.toString(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot execute " + command.toString(), e);
        }
    }

    private Thread showProcessOutput(final InputStream from, final PrintStream to) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int c;
                    while ((c = from.read()) != -1) {
                        to.write((char)c);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        t.start();
        return t;
    }
}

