/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.google.common.base.Throwables;
import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandProcessor;
import com.xebialabs.overcast.command.NonZeroCodeException;
import com.xebialabs.overcast.host.VagrantCloudHost;
import com.xebialabs.overcast.support.vagrant.VagrantDriver;
import com.xebialabs.overcast.support.vagrant.VagrantState;
import com.xebialabs.overcast.support.virtualbox.VirtualboxDriver;
import com.xebialabs.overcast.support.virtualbox.VirtualboxState;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedVagrantCloudHost
extends VagrantCloudHost {
    public static final String EXPIRATION_TAG_PROPERTY_KEY = "overcastExpirationTag";
    public static final int CONNECTION_ATTEMPTS = 100;
    public static final int CONNECTION_RETRY_DELAY = 2000;
    private Command expirationCmd;
    private VirtualboxDriver virtualboxDriver;
    private CommandProcessor commandProcessor;
    private OverthereConnectionBuilder connectionBuilder;
    private static Logger logger = LoggerFactory.getLogger(VagrantCloudHost.class);

    public CachedVagrantCloudHost(String vm, String ip, Command cmd, VagrantDriver vagrantDriver, VirtualboxDriver vboxDriver, CommandProcessor commandProcessor, OverthereConnectionBuilder cb) {
        super(vm, ip, vagrantDriver);
        this.virtualboxDriver = vboxDriver;
        this.expirationCmd = cmd;
        this.commandProcessor = commandProcessor;
        this.connectionBuilder = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup() {
        String expirationTag;
        try {
            logger.info("Executing expiration command: {}", (Object)this.expirationCmd);
            expirationTag = this.commandProcessor.run(this.expirationCmd).getOutput().trim();
        }
        catch (NonZeroCodeException e) {
            throw this.toExternalException(e);
        }
        logger.info("Expiration tag: {}", (Object)expirationTag);
        if (VagrantState.NOT_CREATED.equals((Object)this.vagrantDriver.state(this.vagrantVm))) {
            super.setup();
            logger.info("Attaching tag to the VM");
            this.virtualboxDriver.setExtraData(this.vagrantVm, EXPIRATION_TAG_PROPERTY_KEY, expirationTag);
            logger.info("Taking a snapshot to be used in future when the tag matches");
            this.virtualboxDriver.createSnapshot(this.vagrantVm, expirationTag);
            return;
        }
        if (expirationTag.equals(this.virtualboxDriver.getExtraData(this.vagrantVm, EXPIRATION_TAG_PROPERTY_KEY))) {
            logger.info("Cache hit. Loading the latest snapshot of the VM");
            this.virtualboxDriver.loadLatestSnapshot(this.vagrantVm);
            logger.info("Waiting for the VM to become accessible...");
            boolean connected = false;
            int currentAttempt = 1;
            while (!connected && currentAttempt < 100) {
                try {
                    OverthereConnection c = this.connectionBuilder.connect();
                    try {
                        c.execute(CmdLine.build((String[])new String[]{"hostname"}));
                        connected = true;
                    }
                    finally {
                        c.close();
                    }
                }
                catch (RuntimeIOException re) {
                    logger.info(re.getMessage());
                    logger.info("Proceeding with attempt {}", (Object)(++currentAttempt));
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException se) {
                        Throwables.propagate((Throwable)se);
                    }
                }
            }
        } else {
            logger.info("Expiration tag does not match. Recreating the VM");
            this.vagrantDriver.doVagrant(this.vagrantVm, "destroy", "-f");
            this.setup();
        }
    }

    @Override
    public void teardown() {
        logger.info("Preparing to teardown the VM");
        String tag = this.virtualboxDriver.getExtraData(this.vagrantVm, EXPIRATION_TAG_PROPERTY_KEY);
        if (tag == null) {
            logger.debug("Not found any expiration tag. Falling back to the standard process.");
            super.teardown();
        } else {
            logger.info("Found expiration tag {}", (Object)tag);
            VirtualboxState state = this.virtualboxDriver.vmState(this.vagrantVm);
            if (VirtualboxState.RUNNING == state) {
                logger.info("Powering off VM '{}'", (Object)this.vagrantVm);
                this.virtualboxDriver.powerOff(this.vagrantVm);
            } else {
                logger.info("VM '{}' already shut down (state={}).", (Object)this.vagrantVm, (Object)state);
            }
        }
    }

    private IllegalArgumentException toExternalException(NonZeroCodeException e) {
        return new IllegalArgumentException(String.format("Command %s returned code %s with the following errors: \n\n%s\n", e.getCommand().toString(), e.getResponse().getReturnCode(), e.getResponse().getErrors() + "\n\n" + e.getResponse().getOutput()));
    }
}

