/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.support.docker.DockerDriver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHost
implements CloudHost {
    private final DockerDriver dockerDriver;
    private String image;
    private List<String> command;
    private boolean exposeAllPorts = false;
    private URI uri;
    private String name;
    private boolean remove;
    private List<String> env;
    private Set<String> exposedPorts;
    private static final Logger logger = LoggerFactory.getLogger(DockerHost.class);

    public DockerHost(String image, String dockerHostName) {
        try {
            this.uri = new URI(dockerHostName);
        }
        catch (URISyntaxException e) {
            logger.error("could not parse host name", (Throwable)e);
            throw new IllegalArgumentException("could not parse host name");
        }
        this.image = image;
        this.dockerDriver = new DockerDriver(this);
    }

    @Override
    public void setup() {
        this.dockerDriver.runContainer();
    }

    @Override
    public void teardown() {
        this.dockerDriver.killAndRemoveContainer();
    }

    @Override
    public int getPort(int port) {
        return this.dockerDriver.getPort(port);
    }

    @Override
    public String getHostName() {
        return this.uri.getHost();
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public boolean isExposeAllPorts() {
        return this.exposeAllPorts;
    }

    public URI getUri() {
        return this.uri;
    }

    public DockerDriver getDockerDriver() {
        return this.dockerDriver;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public void setExposeAllPorts(boolean exposeAllPorts) {
        this.exposeAllPorts = exposeAllPorts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public List<String> getEnv() {
        return this.env;
    }

    public void setEnv(List<String> env) {
        this.env = env;
    }

    public Set<String> getExposedPorts() {
        return this.exposedPorts;
    }

    public void setExposedPorts(Set<String> exposedPorts) {
        this.exposedPorts = exposedPorts;
    }
}

