/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.docker;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.xebialabs.overcast.host.DockerHost;
import com.xebialabs.overcast.support.docker.ProcessHandlerLogger;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerDriver {
    private DockerHost dockerHost;
    private Map portMappings;
    private DockerClient dockerClient;
    private String containerId;
    private ContainerConfig config;
    private static final Logger logger = LoggerFactory.getLogger(DockerDriver.class);

    public DockerDriver(DockerHost dockerHost) {
        this.dockerHost = dockerHost;
        this.dockerClient = new DefaultDockerClient(dockerHost.getUri());
    }

    private void buildImageConfig() {
        ContainerConfig.Builder configBuilder = ContainerConfig.builder().image(this.dockerHost.getImage());
        if (this.dockerHost.getCommand() != null) {
            configBuilder.cmd(this.dockerHost.getCommand());
        }
        if (this.dockerHost.getEnv() != null) {
            configBuilder.env(this.dockerHost.getEnv());
        }
        if (this.dockerHost.getExposedPorts() != null) {
            configBuilder.exposedPorts(this.dockerHost.getExposedPorts());
        }
        this.config = configBuilder.build();
    }

    public void runContainer() {
        this.buildImageConfig();
        try {
            try {
                this.createImage();
            }
            catch (ImageNotFoundException e) {
                this.dockerClient.pull(this.dockerHost.getImage(), (ProgressHandler)new ProcessHandlerLogger());
                this.createImage();
            }
            if (this.dockerHost.isExposeAllPorts()) {
                HostConfig hostConfig = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).build();
                this.dockerClient.startContainer(this.containerId, hostConfig);
            } else {
                this.dockerClient.startContainer(this.containerId);
            }
            ContainerInfo info = this.dockerClient.inspectContainer(this.containerId);
            this.portMappings = info.networkSettings().ports();
        }
        catch (Exception e) {
            logger.error("Error while setting up docker host: ", (Throwable)e);
        }
    }

    private void createImage() throws DockerException, InterruptedException {
        this.containerId = this.dockerHost.getName() == null ? this.dockerClient.createContainer(this.config).id() : this.dockerClient.createContainer(this.config, this.dockerHost.getName()).id();
    }

    public void killAndRemoveContainer() {
        try {
            this.dockerClient.killContainer(this.containerId);
            if (this.dockerHost.isRemove()) {
                this.dockerClient.removeContainer(this.containerId);
            }
        }
        catch (Exception e) {
            logger.error("Error while tearing down docker host: ", (Throwable)e);
        }
    }

    public int getPort(int port) {
        ArrayList bindings = (ArrayList)this.portMappings.get(port + "/tcp");
        if (bindings != null && bindings.size() > 0) {
            return Integer.parseInt(((PortBinding)bindings.get(0)).hostPort());
        }
        throw new IllegalArgumentException("Port not available");
    }

    public String getContainerId() {
        return this.containerId;
    }
}

