/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt;

import com.google.common.collect.Lists;
import com.xebialabs.overcast.support.libvirt.JDomUtil;
import com.xebialabs.overcast.support.libvirt.LibvirtRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdom2.Document;
import org.libvirt.Connect;
import org.libvirt.Domain;
import org.libvirt.LibvirtException;
import org.libvirt.StoragePool;
import org.libvirt.StorageVol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibvirtUtil {
    private static final Logger log = LoggerFactory.getLogger(LibvirtUtil.class);
    private static final Lock connectLock = new ReentrantLock();

    private LibvirtUtil() {
    }

    public static StorageVol findVolume(Connect connection, String path) throws LibvirtException {
        log.debug("Looking up StorageVolume for path '{}'", (Object)path);
        for (String s : connection.listStoragePools()) {
            StoragePool sp = connection.storagePoolLookupByName(s);
            for (String v : sp.listVolumes()) {
                StorageVol vol = sp.storageVolLookupByName(v);
                if (!vol.getPath().equals(path)) continue;
                log.debug("Found volume '{}' for path '{}'", (Object)vol.getName(), (Object)path);
                return vol;
            }
        }
        throw new LibvirtRuntimeException("no volume found for path " + path);
    }

    public static StoragePool findStoragePoolWithFile(Connect conn, String path) throws LibvirtException {
        for (String spn : conn.listStoragePools()) {
            StoragePool sp = conn.storagePoolLookupByName(spn);
            if (LibvirtUtil.findVolumeInPool(sp, path) == null) continue;
            log.debug("Found storage pool '{}' for image '{}'", (Object)sp.getName(), (Object)path);
            return sp;
        }
        throw new LibvirtRuntimeException("pool with image " + path + " not found");
    }

    private static StorageVol findVolumeInPool(StoragePool sp, String image) throws LibvirtException {
        for (String v : sp.listVolumes()) {
            StorageVol vol = sp.storageVolLookupByName(v);
            if (!vol.getPath().equals(image)) continue;
            log.debug("Found volume '{}' for image '{}'", (Object)vol.getName(), (Object)image);
            return vol;
        }
        return null;
    }

    public static Document loadDomainXml(Domain domain) {
        try {
            return JDomUtil.stringToDocument(domain.getXMLDesc(0));
        }
        catch (IllegalArgumentException e) {
            throw new LibvirtRuntimeException("Unable to parse domain xml", e);
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to parse domain xml", e);
        }
    }

    public static List<Domain> getDefinedDomains(Connect libvirt) {
        try {
            String[] domainNames;
            ArrayList domains = Lists.newArrayList();
            for (String name : domainNames = libvirt.listDefinedDomains()) {
                domains.add(libvirt.domainLookupByName(name));
            }
            return domains;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to list defined domains", e);
        }
    }

    public static List<Domain> getRunningDomains(Connect libvirt) {
        try {
            int[] ids;
            ArrayList domains = Lists.newArrayList();
            for (int id : ids = libvirt.listDomains()) {
                domains.add(libvirt.domainLookupByID(id));
            }
            return domains;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to list defined domains", e);
        }
    }

    public static Connect getConnection(String libvirtURL, boolean readOnly) {
        connectLock.lock();
        try {
            Connect connect = new Connect(libvirtURL, readOnly);
            return connect;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to connect to " + libvirtURL, e);
        }
        finally {
            connectLock.unlock();
        }
    }
}

