/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.xebialabs.overcast.support.libvirt.JDomUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Metadata {
    private static final String XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String METADATA_NS_V1 = "http://www.xebialabs.com/overcast/metadata/v1";
    public static final String METADATA = "metadata";
    public static final String OVERCAST_METADATA = "overcast_metadata";
    public static final String CREATION_TIME = "creation_time";
    public static final String PROVISIONED_CHECKSUM = "provisioned_checksum";
    public static final String PROVISIONED_WITH = "provisioned_with";
    public static final String PARENT_DOMAIN = "parent_domain";
    private static final TimeZone METADATA_TIMEZONE = TimeZone.getTimeZone("UTC");
    private final String parentDomain;
    private final String provisionedWith;
    private final String provisionedChecksum;
    private final Date creationTime;

    public Metadata(String parentDomain, String provisionedWith, String provisionedChecksum, Date creationTime) {
        Preconditions.checkNotNull((Object)creationTime, (Object)"creationTime cannot be null");
        this.parentDomain = Metadata.checkArgument(parentDomain, "parentDomain");
        this.provisionedWith = Metadata.checkArgument(provisionedWith, "provisionedWith");
        this.provisionedChecksum = Metadata.checkArgument(provisionedChecksum, "provisionedChecksum");
        this.creationTime = creationTime;
    }

    public Metadata(String parentDomain, Date creationTime) {
        Preconditions.checkNotNull((Object)creationTime, (Object)"creationTime cannot be null");
        this.parentDomain = Metadata.checkArgument(parentDomain, "parentDomain");
        this.creationTime = creationTime;
        this.provisionedWith = null;
        this.provisionedChecksum = null;
    }

    private static String checkArgument(String arg, String argName) {
        Preconditions.checkArgument((arg != null && !arg.isEmpty() ? 1 : 0) != 0, (String)"%s cannot be null or empty", (Object[])new Object[]{argName});
        return arg;
    }

    public String getParentDomain() {
        return this.parentDomain;
    }

    public String getProvisionedWith() {
        return this.provisionedWith;
    }

    public String getProvisionedChecksum() {
        return this.provisionedChecksum;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public boolean isProvisioned() {
        return this.provisionedWith != null;
    }

    public static Metadata fromXml(Document domainXml) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(XML_DATE_FORMAT);
            Element metadata = Metadata.getMetadataElement(domainXml);
            if (metadata == null) {
                return null;
            }
            Namespace ns = Namespace.getNamespace((String)METADATA_NS_V1);
            Element ocMetadata = metadata.getChild(OVERCAST_METADATA, ns);
            if (ocMetadata == null) {
                return null;
            }
            String parentDomain = JDomUtil.getElementText(ocMetadata, PARENT_DOMAIN, ns);
            String creationTime = JDomUtil.getElementText(ocMetadata, CREATION_TIME, ns);
            Date date = sdf.parse(creationTime);
            if (ocMetadata.getChild(PROVISIONED_WITH, ns) != null) {
                String provisionedWith = JDomUtil.getElementText(ocMetadata, PROVISIONED_WITH, ns);
                String checkSum = JDomUtil.getElementText(ocMetadata, PROVISIONED_CHECKSUM, ns);
                return new Metadata(parentDomain, provisionedWith, checkSum, date);
            }
            return new Metadata(parentDomain, date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date in metadata on domain", e);
        }
    }

    private static Element createProvisioningMetadata(String parentDomain, String provisionedWith, String provisionedChecksum, Date provisionedAt) {
        SimpleDateFormat sdf = new SimpleDateFormat(XML_DATE_FORMAT);
        sdf.setTimeZone(METADATA_TIMEZONE);
        Element metadata = new Element(METADATA);
        Element ocmetadata = new Element(OVERCAST_METADATA, METADATA_NS_V1);
        metadata.addContent((Content)ocmetadata);
        ocmetadata.addContent((Content)new Element(PARENT_DOMAIN, METADATA_NS_V1).setText(parentDomain));
        ocmetadata.addContent((Content)new Element(PROVISIONED_WITH, METADATA_NS_V1).setText(provisionedWith));
        ocmetadata.addContent((Content)new Element(PROVISIONED_CHECKSUM, METADATA_NS_V1).setText(provisionedChecksum));
        ocmetadata.addContent((Content)new Element(CREATION_TIME, METADATA_NS_V1).setText(sdf.format(provisionedAt)));
        return metadata;
    }

    private static Element createCloningMetadata(String parentDomain, Date creationTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(XML_DATE_FORMAT);
        sdf.setTimeZone(METADATA_TIMEZONE);
        Element metadata = new Element(METADATA);
        Element ocmetadata = new Element(OVERCAST_METADATA, METADATA_NS_V1);
        metadata.addContent((Content)ocmetadata);
        ocmetadata.addContent((Content)new Element(PARENT_DOMAIN, METADATA_NS_V1).setText(parentDomain));
        ocmetadata.addContent((Content)new Element(CREATION_TIME, METADATA_NS_V1).setText(sdf.format(creationTime)));
        return metadata;
    }

    private static Element getMetadataElement(Document domainXml) {
        Element metadata = domainXml.getRootElement().getChild(METADATA);
        if (metadata == null) {
            return null;
        }
        return metadata;
    }

    public static void updateProvisioningMetadata(Document domainXml, String baseDomainName, String provisionCmd, String expirationTag, Date creationTime) {
        Metadata.checkArgument(baseDomainName, "baseDomainName");
        Metadata.checkArgument(provisionCmd, "provisionCmd");
        Metadata.checkArgument(expirationTag, "expirationTag");
        Preconditions.checkNotNull((Object)creationTime, (Object)"creationTime must not be null");
        Element element = Metadata.getMetadataElement(domainXml);
        if (element != null) {
            domainXml.getRootElement().removeContent((Content)element);
        }
        Element metadata = Metadata.createProvisioningMetadata(baseDomainName, provisionCmd, expirationTag, creationTime);
        domainXml.getRootElement().addContent((Content)metadata);
    }

    public static void updateCloneMetadata(Document domainXml, String baseDomainName, Date creationTime) {
        Metadata.checkArgument(baseDomainName, "baseDomainName");
        Preconditions.checkNotNull((Object)creationTime, (Object)"creationTime must not be null");
        Element element = Metadata.getMetadataElement(domainXml);
        if (element != null) {
            domainXml.getRootElement().removeContent((Content)element);
        }
        Element metadata = Metadata.createCloningMetadata(baseDomainName, creationTime);
        domainXml.getRootElement().addContent((Content)metadata);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("parentDomain", (Object)this.parentDomain).add("creationTime", (Object)this.creationTime).add("provisionedChecksum", (Object)this.provisionedChecksum).add("provisionedWith", (Object)this.provisionedWith).toString();
    }
}

