/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.virtualbox;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandProcessor;
import com.xebialabs.overcast.support.virtualbox.VirtualboxState;
import java.util.Collection;
import java.util.Map;

public class VirtualboxDriver {
    private CommandProcessor commandProcessor;

    public VirtualboxDriver(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public VirtualboxState vmState(String vm) {
        return VirtualboxState.fromStatusString(this.execute("showvminfo", vm));
    }

    public boolean vmExists(final String vmOrUuid) {
        return Collections2.filter((Collection)Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.execute("list", "vms"))), (Predicate)new Predicate<String>(){

            public boolean apply(String i) {
                return i.endsWith("{" + vmOrUuid + "}") || i.startsWith("\"" + vmOrUuid + "\"");
            }
        }).size() == 1;
    }

    public void loadSnapshot(String vm, String snapshotUuid) {
        if (!Sets.newHashSet((Object[])new VirtualboxState[]{VirtualboxState.POWEROFF, VirtualboxState.SAVED}).contains((Object)this.vmState(vm))) {
            this.powerOff(vm);
        }
        this.execute("snapshot", vm, "restore", snapshotUuid);
        this.start(vm);
    }

    public void loadLatestSnapshot(String vm) {
        Map split = Splitter.on((char)'\n').omitEmptyStrings().withKeyValueSeparator("=").split((CharSequence)this.execute("snapshot", vm, "list", "--machinereadable"));
        String quotedId = (String)split.get("CurrentSnapshotUUID");
        this.loadSnapshot(vm, quotedId.substring(1, quotedId.length() - 1));
    }

    public void powerOff(String vm) {
        this.execute("controlvm", vm, "poweroff");
    }

    public void start(String vm) {
        this.execute("startvm", vm, "--type", "headless");
    }

    public String execute(String ... command) {
        return this.commandProcessor.run(Command.aCommand("VBoxManage").withArguments(command)).getOutput();
    }

    public void setExtraData(String vm, String k, String v) {
        this.execute("setextradata", vm, k, v);
    }

    public String getExtraData(String vm, String k) {
        String prefix = "Value: ";
        String v = this.execute("getextradata", vm, k).trim();
        return v.equals("No value set!") ? null : v.substring("Value: ".length());
    }

    public void createSnapshot(String vm, String name) {
        this.execute("snapshot", vm, "take", name, "--description", "'Snapshot taken by Overcast.'");
    }
}

