/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.virtualbox;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Arrays;

public enum VirtualboxState {
    POWEROFF,
    ABORTED,
    SAVED,
    RUNNING;


    public static VirtualboxState fromStatusString(String s) {
        String stateString = (String)Iterables.getOnlyElement((Iterable)Collections2.filter(Arrays.asList(s.split("\n")), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith("State:");
            }
        }));
        if (stateString.contains("powered off")) {
            return POWEROFF;
        }
        if (stateString.contains("saved")) {
            return POWEROFF;
        }
        if (stateString.contains("aborted")) {
            return ABORTED;
        }
        if (stateString.contains("running")) {
            return RUNNING;
        }
        throw new IllegalStateException("Can not detect state for state string: " + stateString);
    }
}

