/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Command {
    private List<String> command = new ArrayList<String>();

    private Command() {
    }

    public static Command aCommand(String executable) {
        if (executable == null) {
            throw new IllegalArgumentException("Executable can not be null");
        }
        Command c = new Command();
        c.withPart(executable);
        return c;
    }

    public Command withPart(String ... part) {
        if (part == null) {
            return this;
        }
        for (String p : part) {
            if (p == null) continue;
            this.command.add(p);
        }
        return this;
    }

    public Command withArguments(String ... argument) {
        return this.withPart(argument);
    }

    public Command withOptions(String ... option) {
        return this.withPart(option);
    }

    public Command withPrefix(String prefix) {
        return this.withPart(prefix);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = this.command.iterator();
        if (iterator.hasNext()) {
            builder.append(iterator.next());
        }
        while (iterator.hasNext()) {
            builder.append(' ').append(iterator.next());
        }
        return builder.toString();
    }

    public static Command fromString(String s) {
        Command c = new Command();
        for (String part : s.split("\\s")) {
            c.getCommand().add(part);
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Command)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        int c = 1000;
        for (char ch : this.toString().toCharArray()) {
            c += ch;
        }
        return c;
    }

    public List<String> asList() {
        return Arrays.asList(this.getCommand().toArray(new String[this.getCommand().size()]));
    }
}

