/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.xebialabs.overcast.OvercastProperties;
import com.xebialabs.overcast.Strings;
import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandProcessor;
import com.xebialabs.overcast.host.CachedLibvirtHost;
import com.xebialabs.overcast.host.CachedVagrantCloudHost;
import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.host.DockerHost;
import com.xebialabs.overcast.host.Ec2CloudHost;
import com.xebialabs.overcast.host.ExistingCloudHost;
import com.xebialabs.overcast.host.LibvirtHost;
import com.xebialabs.overcast.host.TunneledCloudHost;
import com.xebialabs.overcast.host.VagrantCloudHost;
import com.xebialabs.overcast.host.VirtualboxHost;
import com.xebialabs.overcast.support.libvirt.Filesystem;
import com.xebialabs.overcast.support.libvirt.IpLookupStrategy;
import com.xebialabs.overcast.support.libvirt.LibvirtUtil;
import com.xebialabs.overcast.support.vagrant.VagrantDriver;
import com.xebialabs.overcast.support.virtualbox.VirtualboxDriver;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.ssh.SshConnectionBuilder;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.libvirt.Connect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHostFactory {
    public static final String HOSTNAME_PROPERTY_SUFFIX = ".hostname";
    public static final String TUNNEL_USERNAME_PROPERTY_SUFFIX = ".tunnel.username";
    public static final String TUNNEL_PASSWORD_PROPERTY_SUFFIX = ".tunnel.password";
    public static final String TUNNEL_PORTS_PROPERTY_SUFFIX = ".tunnel.ports";
    public static final String TUNNEL_SETUP_TIMEOUT = ".tunnel.setupTimeout";
    public static final String TUNNEL_DEFAULT_SETUP_TIMEOUT = "0";
    private static final String VAGRANT_DIR_PROPERTY_SUFFIX = ".vagrantDir";
    private static final String VAGRANT_VM_PROPERTY_SUFFIX = ".vagrantVm";
    private static final String VAGRANT_IP_PROPERTY_SUFFIX = ".vagrantIp";
    private static final String VAGRANT_SNAPSHOT_EXPIRATION_CMD = ".vagrantSnapshotExpirationCmd";
    private static final String VAGRANT_OS_PROPERTY_SUFFIX = ".vagrantOs";
    private static final String VBOX_UUID_PROPERTY_SUFFIX = ".vboxUuid";
    private static final String VBOX_IP = ".vboxBoxIp";
    private static final String VBOX_SNAPSHOT = ".vboxSnapshotUuid";
    public static Logger logger = LoggerFactory.getLogger(CloudHostFactory.class);

    public static CloudHost getCloudHostWithNoTeardown(String hostLabel) {
        return CloudHostFactory.getCloudHost(hostLabel, true);
    }

    public static CloudHost getCloudHost(String hostLabel) {
        return CloudHostFactory.getCloudHost(hostLabel, false);
    }

    private static CloudHost getCloudHost(String hostLabel, boolean disableEc2) {
        CloudHost host = CloudHostFactory.createCloudHost(hostLabel, disableEc2);
        return CloudHostFactory.wrapCloudHost(hostLabel, host);
    }

    protected static CloudHost createCloudHost(String label, boolean disableEc2) {
        String hostName = OvercastProperties.getOvercastProperty(label + HOSTNAME_PROPERTY_SUFFIX);
        if (hostName != null) {
            return CloudHostFactory.createExistingCloudHost(label);
        }
        String vagrantDir = OvercastProperties.getOvercastProperty(label + VAGRANT_DIR_PROPERTY_SUFFIX);
        if (vagrantDir != null) {
            return CloudHostFactory.createVagrantCloudHost(label, vagrantDir);
        }
        String amiId = OvercastProperties.getOvercastProperty(label + ".amiId");
        if (amiId != null) {
            return CloudHostFactory.createEc2CloudHost(label, amiId, disableEc2);
        }
        String vboxUuid = OvercastProperties.getOvercastProperty(label + VBOX_UUID_PROPERTY_SUFFIX);
        if (vboxUuid != null) {
            return CloudHostFactory.createVboxHost(label, vboxUuid);
        }
        String kvmBaseDomain = OvercastProperties.getOvercastProperty(label + ".baseDomain");
        if (kvmBaseDomain != null) {
            return CloudHostFactory.createLibvirtHost(label, kvmBaseDomain);
        }
        String dockerImage = OvercastProperties.getOvercastProperty(label + ".dockerImage");
        if (dockerImage != null) {
            return CloudHostFactory.createDockerHost(label, dockerImage);
        }
        throw new IllegalStateException("No valid configuration has been specified for host label " + label);
    }

    private static CloudHost createDockerHost(String label, String image) {
        String dockerHostName = OvercastProperties.getOvercastProperty(label + ".dockerHost");
        String certificates = OvercastProperties.getOvercastProperty(label + ".certificates");
        DockerHost dockerHost = new DockerHost(image, dockerHostName, Strings.isNullOrEmpty(certificates) ? null : Paths.get(certificates, new String[0]));
        dockerHost.setName(OvercastProperties.getOvercastProperty(label + ".name"));
        dockerHost.setCommand(OvercastProperties.getOvercastListProperty(label + ".command"));
        dockerHost.setExposeAllPorts(OvercastProperties.getOvercastBooleanProperty(label + ".exposeAllPorts"));
        dockerHost.setTty(OvercastProperties.getOvercastBooleanProperty(label + ".tty"));
        dockerHost.setRemove(OvercastProperties.getOvercastBooleanProperty(label + ".remove"));
        dockerHost.setRemoveVolume(OvercastProperties.getOvercastBooleanProperty(label + ".removeVolume"));
        dockerHost.setEnv(OvercastProperties.getOvercastListProperty(label + ".env"));
        dockerHost.setExposedPorts(new HashSet<String>(OvercastProperties.getOvercastListProperty(label + ".exposedPorts")));
        dockerHost.setLinks(OvercastProperties.getOvercastListProperty(label + ".links"));
        dockerHost.setPortBindings(new HashSet<String>(OvercastProperties.getOvercastListProperty(label + ".portBindings")));
        return dockerHost;
    }

    private static CloudHost createLibvirtHost(String label, String kvmBaseDomain) {
        String libvirtURL = OvercastProperties.getOvercastProperty(label + ".libvirtURL", "qemu:///system");
        Connect libvirt = LibvirtUtil.getConnection(libvirtURL, false);
        int startTimeout = Integer.valueOf(OvercastProperties.getOvercastProperty(label + ".libvirtStartTimeout", "30"));
        int bootDelay = Integer.valueOf(OvercastProperties.getOvercastProperty(label + ".bootDelay", TUNNEL_DEFAULT_SETUP_TIMEOUT));
        String networkName = OvercastProperties.getOvercastProperty(label + ".network");
        ArrayList<Filesystem> fsMappings = new ArrayList<Filesystem>();
        Set<String> mappingNames = OvercastProperties.getOvercastPropertyNames(label + ".fsMapping");
        for (String mapping : mappingNames) {
            fsMappings.add(CloudHostFactory.createFilesystem(mapping, label + ".fsMapping" + "." + mapping));
        }
        IpLookupStrategy ipLookupStrategy = LibvirtHost.determineIpLookupStrategy(label);
        String provisionCmd = OvercastProperties.getOvercastProperty(label + ".provision.cmd");
        if (provisionCmd == null) {
            return new LibvirtHost(libvirt, kvmBaseDomain, ipLookupStrategy, networkName, startTimeout, bootDelay, fsMappings);
        }
        String provisionUrl = OvercastProperties.getRequiredOvercastProperty(label + ".provision.url");
        String cacheExpirationUrl = OvercastProperties.getOvercastProperty(label + ".provision.expirationTag.url");
        String cacheExpirationCmd = OvercastProperties.getRequiredOvercastProperty(label + ".provision.expirationTag.cmd");
        int provisionStartTimeout = Integer.valueOf(OvercastProperties.getOvercastProperty(label + ".provision.startTimeout", "60"));
        int provisionedBootDelay = Integer.valueOf(OvercastProperties.getOvercastProperty(label + ".provision.bootDelay", TUNNEL_DEFAULT_SETUP_TIMEOUT));
        List<String> copySpec = OvercastProperties.getOvercastListProperty(label + ".provision.copy", Collections.emptyList());
        CommandProcessor cmdProcessor = CommandProcessor.atCurrentDir();
        return new CachedLibvirtHost(label, libvirt, kvmBaseDomain, ipLookupStrategy, networkName, provisionUrl, provisionCmd, cacheExpirationUrl, cacheExpirationCmd, cmdProcessor, startTimeout, bootDelay, provisionStartTimeout, provisionedBootDelay, fsMappings, copySpec);
    }

    private static Filesystem createFilesystem(String target, String path) {
        String source = OvercastProperties.getRequiredOvercastProperty(path + ".hostPath");
        Filesystem.AccessMode accessMode = Filesystem.AccessMode.valueOf(OvercastProperties.getOvercastProperty(path + ".accessMode", Filesystem.AccessMode.PASSTHROUGH.toString()));
        boolean readOnly = Boolean.valueOf(OvercastProperties.getOvercastProperty(path + ".readOnly", "true"));
        return new Filesystem(source, target, accessMode, readOnly);
    }

    private static CloudHost createVboxHost(String label, String vboxUuid) {
        String vboxIp = OvercastProperties.getOvercastProperty(label + VBOX_IP);
        String vboxSnapshot = OvercastProperties.getOvercastProperty(label + VBOX_SNAPSHOT);
        return new VirtualboxHost(vboxIp, vboxUuid, vboxSnapshot);
    }

    private static CloudHost createExistingCloudHost(String label) {
        logger.info("Using existing host for {}", (Object)label);
        return new ExistingCloudHost(label);
    }

    private static CloudHost createVagrantCloudHost(String hostLabel, String vagrantDir) {
        String vagrantVm = OvercastProperties.getOvercastProperty(hostLabel + VAGRANT_VM_PROPERTY_SUFFIX);
        String vagrantIp = OvercastProperties.getOvercastProperty(hostLabel + VAGRANT_IP_PROPERTY_SUFFIX);
        String vagrantExpirationCmd = OvercastProperties.getOvercastProperty(hostLabel + VAGRANT_SNAPSHOT_EXPIRATION_CMD);
        String vagrantOs = OvercastProperties.getOvercastProperty(hostLabel + VAGRANT_OS_PROPERTY_SUFFIX, OperatingSystemFamily.UNIX.toString());
        logger.info("Using Vagrant to create {}", (Object)hostLabel);
        CommandProcessor cmdProcessor = CommandProcessor.atLocation(vagrantDir);
        VagrantDriver vagrantDriver = new VagrantDriver(hostLabel, cmdProcessor);
        VirtualboxDriver vboxDriver = new VirtualboxDriver(cmdProcessor);
        if (vagrantExpirationCmd == null) {
            return new VagrantCloudHost(vagrantVm, vagrantIp, vagrantDriver);
        }
        ConnectionOptions options = new ConnectionOptions();
        options.set("address", (Object)vagrantIp);
        options.set("username", (Object)"vagrant");
        options.set(ConnectionOptions.PASSWORD, (Object)"vagrant");
        CifsConnectionBuilder cb = null;
        if (OperatingSystemFamily.WINDOWS.toString().equals(vagrantOs)) {
            options.set("os", (Object)OperatingSystemFamily.WINDOWS);
            options.set("connectionType", (Object)CifsConnectionType.WINRM_INTERNAL);
            cb = new CifsConnectionBuilder("winrm", options, (AddressPortMapper)new DefaultAddressPortMapper());
        } else {
            options.set("os", (Object)OperatingSystemFamily.UNIX);
            options.set("connectionType", (Object)SshConnectionType.SFTP);
            cb = new SshConnectionBuilder("ssh", options, (AddressPortMapper)new DefaultAddressPortMapper());
        }
        return new CachedVagrantCloudHost(vagrantVm, vagrantIp, Command.fromString(vagrantExpirationCmd), vagrantDriver, vboxDriver, cmdProcessor, (OverthereConnectionBuilder)cb);
    }

    private static CloudHost createEc2CloudHost(String label, String amiId, boolean disableEc2) {
        if (disableEc2) {
            throw new IllegalStateException("Only an AMI ID (" + amiId + ") has been specified for host label " + label + ", but EC2 hosts are not available.");
        }
        logger.info("Using Amazon EC2 for {}", (Object)label);
        return new Ec2CloudHost(label, amiId);
    }

    private static CloudHost wrapCloudHost(String label, CloudHost actualHost) {
        String tunnelUsername = OvercastProperties.getOvercastProperty(label + TUNNEL_USERNAME_PROPERTY_SUFFIX);
        if (tunnelUsername == null) {
            return actualHost;
        }
        logger.info("Starting SSH tunnels for {}", (Object)label);
        String tunnelPassword = OvercastProperties.getRequiredOvercastProperty(label + TUNNEL_PASSWORD_PROPERTY_SUFFIX);
        String ports = OvercastProperties.getRequiredOvercastProperty(label + TUNNEL_PORTS_PROPERTY_SUFFIX);
        int timeout = Integer.parseInt(OvercastProperties.getOvercastProperty(label + TUNNEL_SETUP_TIMEOUT, TUNNEL_DEFAULT_SETUP_TIMEOUT));
        Map<Integer, Integer> portForwardMap = OvercastProperties.parsePortsProperty(ports);
        return new TunneledCloudHost(actualHost, tunnelUsername, tunnelPassword, portForwardMap, timeout);
    }
}

