/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.host;

import com.xebialabs.overcast.host.CloudHost;
import com.xebialabs.overcast.support.vagrant.VagrantDriver;
import com.xebialabs.overcast.support.vagrant.VagrantState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VagrantCloudHost
implements CloudHost {
    protected String vagrantIp;
    protected String vagrantVm;
    protected VagrantDriver vagrantDriver;
    private VagrantState initialState;
    private static Logger logger = LoggerFactory.getLogger(VagrantCloudHost.class);

    public VagrantCloudHost(String vagrantVm, String vagrantIp, VagrantDriver vagrantDriver) {
        this.vagrantIp = vagrantIp;
        this.vagrantDriver = vagrantDriver;
        this.vagrantVm = vagrantVm;
    }

    @Override
    public void setup() {
        this.initialState = this.vagrantDriver.state(this.vagrantVm);
        logger.info("Vagrant host is in state {}.", (Object)this.initialState.toString());
        this.vagrantDriver.doVagrant(this.vagrantVm, VagrantState.getTransitionCommand(VagrantState.RUNNING));
    }

    @Override
    public void teardown() {
        VagrantState nextState;
        if (this.initialState != null) {
            logger.info("Bringing vagrant back to {} state.", (Object)this.initialState.toString());
            nextState = this.initialState;
        } else {
            logger.warn("No initial state was captured. Destroying the VM.");
            nextState = VagrantState.NOT_CREATED;
        }
        this.vagrantDriver.doVagrant(this.vagrantVm, VagrantState.getTransitionCommand(nextState));
    }

    @Override
    public String getHostName() {
        return this.vagrantIp;
    }

    @Override
    public int getPort(int port) {
        return port;
    }
}

