/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.docker;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ContainerState;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.xebialabs.overcast.host.DockerHost;
import com.xebialabs.overcast.support.docker.ProcessHandlerLogger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerDriver {
    private final DockerHost dockerHost;
    private final DockerClient dockerClient;
    private Map<String, List<PortBinding>> portMappings;
    private String containerId;
    private ContainerConfig config;
    private static final Logger logger = LoggerFactory.getLogger(DockerDriver.class);

    public DockerDriver(DockerHost dockerHost, Path certificatesPath) {
        this.dockerHost = dockerHost;
        this.dockerClient = DockerDriver.buildClient(dockerHost.getUri(), certificatesPath);
    }

    public static DockerClient buildClient(URI dockerHost, Path certificatesPath) {
        try {
            if (dockerHost == null) {
                logger.info("Configuring docker host from environment");
                return DefaultDockerClient.fromEnv().build();
            }
            logger.info("Configuring docker host from configuration");
            DefaultDockerClient.Builder builder = DefaultDockerClient.builder().uri(dockerHost);
            if (certificatesPath != null) {
                builder.dockerCertificates(new DockerCertificates(certificatesPath));
            }
            return builder.build();
        }
        catch (DockerCertificateException e) {
            logger.error("Could not read certificates", (Throwable)e);
            throw new IllegalArgumentException("Could not read certificates: " + e.getMessage());
        }
    }

    private void buildImageConfig() {
        ContainerConfig.Builder configBuilder = ContainerConfig.builder().image(this.dockerHost.getImage());
        if (this.dockerHost.getCommand() != null) {
            configBuilder.cmd(this.dockerHost.getCommand());
        }
        if (this.dockerHost.getEnv() != null) {
            configBuilder.env(this.dockerHost.getEnv());
        }
        if (this.dockerHost.getExposedPorts() != null) {
            configBuilder.exposedPorts(this.dockerHost.getExposedPorts());
        }
        if (this.dockerHost.isTty()) {
            configBuilder.tty(Boolean.valueOf(true));
        }
        HostConfig.Builder hostConfigBuilder = HostConfig.builder().publishAllPorts(Boolean.valueOf(this.dockerHost.isExposeAllPorts())).links(this.dockerHost.getLinks());
        if (this.dockerHost.hasPortBindings()) {
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            for (String binding : this.dockerHost.getPortBindings()) {
                String[] bindings = binding.split(":");
                String containerPort = bindings[1];
                PortBinding hostBinding = PortBinding.of((String)"0.0.0.0", (String)bindings[0]);
                portBindings.put(containerPort, Collections.singletonList(hostBinding));
            }
            hostConfigBuilder.portBindings(portBindings);
        }
        configBuilder.hostConfig(hostConfigBuilder.build());
        this.config = configBuilder.build();
    }

    public void runContainer() {
        try {
            this.buildImageConfig();
            try {
                this.createImage();
            }
            catch (ImageNotFoundException e) {
                this.dockerClient.pull(this.dockerHost.getImage(), (ProgressHandler)new ProcessHandlerLogger());
                this.createImage();
            }
            this.dockerClient.startContainer(this.containerId);
            ContainerInfo info = this.dockerClient.inspectContainer(this.containerId);
            this.portMappings = info.networkSettings().ports();
        }
        catch (DockerException | InterruptedException e) {
            logger.error("Error while setting up docker container", e);
            throw new RuntimeException("Error while setting up docker container", e);
        }
    }

    private void createImage() throws DockerException, InterruptedException {
        this.containerId = this.dockerHost.getName() == null ? this.dockerClient.createContainer(this.config).id() : this.dockerClient.createContainer(this.config, this.dockerHost.getName()).id();
    }

    public void killAndRemoveContainer() {
        try {
            ContainerState state = this.dockerClient.inspectContainer(this.containerId).state();
            if (Boolean.TRUE.equals(state.running())) {
                this.dockerClient.killContainer(this.containerId);
            }
            if (this.dockerHost.isRemove()) {
                this.dockerClient.removeContainer(this.containerId, new DockerClient.RemoveContainerParam[]{DockerClient.RemoveContainerParam.removeVolumes((boolean)this.dockerHost.isRemoveVolume())});
            }
        }
        catch (DockerException | InterruptedException e) {
            logger.error("Error while tearing down docker container", e);
            throw new RuntimeException("Error while tearing down docker container", e);
        }
    }

    public String getHost() {
        return this.dockerClient.getHost();
    }

    public int getPort(int port) {
        List<PortBinding> bindings = this.portMappings.get(port + "/tcp");
        if (bindings != null && bindings.size() > 0) {
            return Integer.parseInt(bindings.get(0).hostPort());
        }
        throw new IllegalArgumentException("Port not available");
    }

    public String getContainerId() {
        return this.containerId;
    }
}

