/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt;

import com.xebialabs.overcast.Preconditions;
import com.xebialabs.overcast.support.libvirt.LibvirtRuntimeException;
import com.xebialabs.overcast.support.libvirt.jdom.DiskXml;
import java.io.IOException;
import org.libvirt.LibvirtException;
import org.libvirt.StoragePool;
import org.libvirt.StorageVol;
import org.libvirt.StorageVolInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Disk {
    private static final Logger log = LoggerFactory.getLogger(Disk.class);
    public String device;
    public String file;
    public String format;
    private StorageVol volume;

    public Disk(String device, String file, StorageVol volume, String format) {
        Preconditions.checkNotNullOrEmpty(device);
        Preconditions.checkNotNullOrEmpty(file);
        Preconditions.checkNotNull(volume);
        Preconditions.checkNotNullOrEmpty(format);
        this.device = device;
        this.file = file;
        this.volume = volume;
        this.format = format;
    }

    public StorageVolInfo getInfo() {
        try {
            return this.volume.getInfo();
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(e);
        }
    }

    public String getName() {
        try {
            return this.volume.getName();
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(e);
        }
    }

    public String getBaseName() {
        String name = this.getName();
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return name;
        }
        return name.substring(0, idx);
    }

    public StorageVol getVolume() {
        return this.volume;
    }

    public StoragePool getStoragePool() {
        try {
            return this.volume.storagePoolLookupByVolume();
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(e);
        }
    }

    public StorageVol createCloneWithBackingStore(String name) {
        try {
            String volumeXml = DiskXml.cloneVolumeXml(this, name);
            log.debug("Creating volume with xml={}", (Object)volumeXml);
            StorageVol vol = this.getStoragePool().storageVolCreateXML(volumeXml, 0);
            return vol;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(e);
        }
        catch (IOException e) {
            throw new LibvirtRuntimeException(e);
        }
    }

    public String toString() {
        return "Disk{name=" + this.getName() + ", format='" + this.format + '\'' + ", file='" + this.file + '\'' + ", device='" + this.device + '\'' + '}';
    }
}

