/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt;

import com.xebialabs.overcast.support.libvirt.Disk;
import com.xebialabs.overcast.support.libvirt.Filesystem;
import com.xebialabs.overcast.support.libvirt.JDomUtil;
import com.xebialabs.overcast.support.libvirt.LibvirtRuntimeException;
import com.xebialabs.overcast.support.libvirt.LibvirtUtil;
import com.xebialabs.overcast.support.libvirt.Metadata;
import com.xebialabs.overcast.support.libvirt.jdom.DiskXml;
import com.xebialabs.overcast.support.libvirt.jdom.DomainXml;
import com.xebialabs.overcast.support.libvirt.jdom.FilesystemXml;
import com.xebialabs.overcast.support.libvirt.jdom.InterfaceXml;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.libvirt.Domain;
import org.libvirt.DomainInfo;
import org.libvirt.LibvirtException;
import org.libvirt.StorageVol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DomainWrapper.class);
    private Document domainXml;
    private Domain domain;

    public DomainWrapper(Domain domain, Document domainXml) {
        this.domain = domain;
        this.domainXml = domainXml;
    }

    public String getName() {
        try {
            return this.domain.getName();
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to get domain name", e);
        }
    }

    public void reloadDomainXml() throws LibvirtException {
        this.domainXml = LibvirtUtil.loadDomainXml(this.domain);
    }

    public static DomainWrapper newWrapper(Domain domain) {
        return new DomainWrapper(domain, LibvirtUtil.loadDomainXml(domain));
    }

    public void destroyWithDisks() {
        try {
            boolean isRunning = this.domain.getInfo().state == DomainInfo.DomainState.VIR_DOMAIN_RUNNING;
            List<Disk> disks = DiskXml.getDisks(this.domain.getConnect(), this.domainXml);
            logger.info("Undefining domain '{}'", (Object)this.domain.getName());
            this.domain.undefine(3);
            if (isRunning) {
                logger.info("Shutting down domain '{}'", (Object)this.domain.getName());
                this.domain.destroy();
            }
            for (Disk disk : disks) {
                logger.info("Removing disk {}", (Object)disk.getName());
                disk.getVolume().delete(0);
            }
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to destroy domain", e);
        }
    }

    public DomainInfo.DomainState getState() {
        try {
            return this.domain.getInfo().state;
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to get domain state", e);
        }
    }

    public String getMac(String id) {
        if (id == null) {
            return null;
        }
        return InterfaceXml.getMacs(this.domainXml).get(id);
    }

    public DomainWrapper cloneWithBackingStore(String cloneName, List<Filesystem> mappings) {
        logger.info("Creating clone from {}", (Object)this.getName());
        try {
            Document cloneXmlDocument = this.domainXml.clone();
            DomainXml.setDomainName(cloneXmlDocument, cloneName);
            DomainXml.prepareForCloning(cloneXmlDocument);
            Metadata.updateCloneMetadata(cloneXmlDocument, this.getName(), new Date());
            this.cloneDisks(cloneXmlDocument, cloneName);
            this.updateFilesystemMappings(cloneXmlDocument, mappings);
            String cloneXml = JDomUtil.documentToString(cloneXmlDocument);
            logger.debug("Clone xml={}", (Object)cloneXml);
            Domain cloneDomain = this.domain.getConnect().domainDefineXML(cloneXml);
            String createdCloneXml = cloneDomain.getXMLDesc(0);
            logger.debug("Created clone xml: {}", (Object)createdCloneXml);
            cloneDomain.create();
            logger.debug("Starting clone: '{}'", (Object)cloneDomain.getName());
            return DomainWrapper.newWrapper(cloneDomain);
        }
        catch (IOException | LibvirtException e) {
            throw new LibvirtRuntimeException("Unable to clone domain", e);
        }
    }

    private void updateFilesystemMappings(Document cloneXmlDocument, List<Filesystem> mappings) {
        Element devices = cloneXmlDocument.getRootElement().getChild("devices");
        Map<String, Filesystem> currentFilesystems = FilesystemXml.getFilesystems(this.domainXml);
        for (Filesystem fs : mappings) {
            if (currentFilesystems.containsKey(fs.target)) {
                FilesystemXml.removeFilesystemsWithTarget(cloneXmlDocument, fs.target);
            }
            devices.addContent((Content)FilesystemXml.toFileSystemXml(fs));
        }
    }

    private void cloneDisks(Document cloneXmlDocument, String cloneName) throws LibvirtException {
        ArrayList<StorageVol> cloneDisks = new ArrayList<StorageVol>();
        int idx = 0;
        for (Disk d : DiskXml.getDisks(this.domain.getConnect(), this.domainXml)) {
            String clonedDisk = String.format("%s-%02d.qcow2", cloneName, ++idx);
            StorageVol vol = d.createCloneWithBackingStore(clonedDisk);
            logger.debug("Disk {} cloned to {}", (Object)d.getName(), (Object)clonedDisk);
            cloneDisks.add(vol);
        }
        DiskXml.updateDisks(cloneXmlDocument, cloneDisks);
    }

    public DomainWrapper cloneWithBackingStore(String cloneName) {
        return this.cloneWithBackingStore(cloneName, Collections.emptyList());
    }

    public Document getDomainXml() {
        return this.domainXml;
    }

    public void updateMetadata(String baseDomainName, String provisionCmd, String expirationTag, Date date) {
        try {
            if (this.domain.isActive() == 1) {
                throw new IllegalStateException("Domain must be shut down before updating metdata");
            }
            this.reloadDomainXml();
            Metadata.updateProvisioningMetadata(this.domainXml, baseDomainName, provisionCmd, expirationTag, date);
            String xml = JDomUtil.documentToString(this.domainXml);
            logger.debug("Updating domain '{}' XML with {}", (Object)this.getName(), (Object)xml);
            this.domain.getConnect().domainDefineXML(xml);
        }
        catch (IOException | LibvirtException e) {
            throw new LibvirtRuntimeException(String.format("Unable to update metadata for domain '%s'", this.getName()), e);
        }
    }

    public void acpiShutdown() {
        logger.info("Shutting down domain '{}'", (Object)this.getName());
        try {
            this.domain.shutdown();
            while (this.domain.isActive() == 1) {
                DomainWrapper.sleep(1);
            }
            logger.debug("Domain '{}' shut down (active={})", (Object)this.getName(), (Object)this.domain.isActive());
        }
        catch (LibvirtException e) {
            throw new LibvirtRuntimeException(String.format("Unable to shut down domain '%s'", this.getName()), e);
        }
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

