/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.libvirt;

import com.xebialabs.overcast.OvercastProperties;
import com.xebialabs.overcast.OverthereUtil;
import com.xebialabs.overcast.Preconditions;
import com.xebialabs.overcast.support.libvirt.IpLookupStrategy;
import com.xebialabs.overcast.support.libvirt.IpNotFoundException;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshIpLookupStrategy
implements IpLookupStrategy {
    private static final Logger log = LoggerFactory.getLogger(SshIpLookupStrategy.class);
    private static final String SSH_TIMEOUT_SUFFIX = ".SSH.timeout";
    private static final String SSH_COMMAND_SUFFIX = ".SSH.command";
    private static final String SSH_URL_SUFFIX = ".SSH.url";
    private URI url;
    private String command;
    private int timeout;

    public SshIpLookupStrategy(URI url, String command, int timeout) {
        this.url = url;
        this.command = command;
        this.timeout = timeout;
    }

    public static SshIpLookupStrategy create(String prefix) {
        try {
            URI uri = new URI(OvercastProperties.getRequiredOvercastProperty(prefix + SSH_URL_SUFFIX));
            String command = OvercastProperties.getRequiredOvercastProperty(prefix + SSH_COMMAND_SUFFIX);
            int timeout = Integer.parseInt(OvercastProperties.getOvercastProperty(prefix + SSH_TIMEOUT_SUFFIX, "60"));
            SshIpLookupStrategy instance = new SshIpLookupStrategy(uri, command, timeout);
            return instance;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String lookup(String mac) {
        Preconditions.checkNotNull(mac, "Need a MAC to lookup the IP of a host.", new Object[0]);
        CmdLine cmdLine = new CmdLine();
        String fragment = MessageFormat.format(this.command, mac);
        cmdLine.addRaw(fragment);
        log.info("Will use command '{}' to detect IP", (Object)cmdLine);
        try (OverthereConnection connection = null;){
            connection = OverthereUtil.overthereConnectionFromURI(this.url);
            int seconds = this.timeout;
            while (seconds > 0) {
                CapturingOverthereExecutionOutputHandler outputHandler = CapturingOverthereExecutionOutputHandler.capturingHandler();
                CapturingOverthereExecutionOutputHandler errorOutputHandler = CapturingOverthereExecutionOutputHandler.capturingHandler();
                connection.execute((OverthereExecutionOutputHandler)outputHandler, (OverthereExecutionOutputHandler)errorOutputHandler, cmdLine);
                if (!errorOutputHandler.getOutputLines().isEmpty()) {
                    throw new RuntimeException("Had stderror: " + errorOutputHandler.getOutput());
                }
                if (outputHandler.getOutputLines().isEmpty()) {
                    SshIpLookupStrategy.sleep(1);
                    log.debug("No IP found yet, will try for {} seconds", (Object)(--seconds));
                    continue;
                }
                String line = (String)outputHandler.getOutputLines().get(0);
                log.debug("Found IP={} for MAC={}", (Object)line, (Object)mac);
                String string = (String)outputHandler.getOutputLines().get(0);
                return string;
            }
        }
        String message = String.format("No IP found for MAC '%s' on host '%s'", mac, this.url.getHost());
        throw new IpNotFoundException(message);
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

