/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overcast.support.virtualbox;

import com.xebialabs.overcast.command.Command;
import com.xebialabs.overcast.command.CommandProcessor;
import com.xebialabs.overcast.support.virtualbox.VirtualboxState;
import java.util.EnumSet;

public class VirtualboxDriver {
    private CommandProcessor commandProcessor;

    public VirtualboxDriver(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public VirtualboxState vmState(String vm) {
        return VirtualboxState.fromStatusString(this.execute("showvminfo", vm));
    }

    public boolean vmExists(String vmOrUuid) {
        String[] lines;
        for (String line : lines = this.execute("list", "vms").split("\\s")) {
            if (!line.endsWith("{" + vmOrUuid + "}") && !line.startsWith("\"" + vmOrUuid + "\"")) continue;
            return true;
        }
        return false;
    }

    public void loadSnapshot(String vm, String snapshotUuid) {
        if (!EnumSet.of(VirtualboxState.POWEROFF, VirtualboxState.SAVED).contains((Object)this.vmState(vm))) {
            this.powerOff(vm);
        }
        this.execute("snapshot", vm, "restore", snapshotUuid);
        this.start(vm);
    }

    public void loadLatestSnapshot(String vm) {
        String[] lines;
        String quotedId = null;
        for (String line : lines = this.execute("snapshot", vm, "list", "--machinereadable").split("\n")) {
            String[] parts;
            if (line.isEmpty() || !(parts = line.split("="))[0].equals("CurrentSnapshotUUID")) continue;
            quotedId = parts[1];
        }
        this.loadSnapshot(vm, quotedId.substring(1, quotedId.length() - 1));
    }

    public void powerOff(String vm) {
        this.execute("controlvm", vm, "poweroff");
    }

    public void start(String vm) {
        this.execute("startvm", vm, "--type", "headless");
    }

    public String execute(String ... command) {
        return this.commandProcessor.run(Command.aCommand("VBoxManage").withArguments(command)).getOutput();
    }

    public void setExtraData(String vm, String k, String v) {
        this.execute("setextradata", vm, k, v);
    }

    public String getExtraData(String vm, String k) {
        String prefix = "Value: ";
        String v = this.execute("getextradata", vm, k).trim();
        return v.equals("No value set!") ? null : v.substring("Value: ".length());
    }

    public void createSnapshot(String vm, String name) {
        this.execute("snapshot", vm, "take", name, "--description", "'Snapshot taken by Overcast.'");
    }
}

