/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLoginModule
implements LoginModule {
    public static final String SHARED_NAME = "javax.security.auth.login.name";
    public static final String SHARED_PASSWORD = "javax.security.auth.login.password";
    private AuthState authState;
    protected final Log log = LogFactory.getLog(this.getClass());

    protected abstract Set authenticate(Map var1) throws LoginException;

    protected Map getCredentials(Map sharedState) {
        HashMap map = new HashMap();
        if (sharedState.containsKey(SHARED_NAME)) {
            map.put(SHARED_NAME, sharedState.get(SHARED_NAME));
        }
        if (sharedState.containsKey(SHARED_PASSWORD)) {
            map.put(SHARED_PASSWORD, sharedState.get(SHARED_PASSWORD));
        }
        return map;
    }

    protected Map getCredentials(CallbackHandler callbackHandler) throws LoginException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NameCallback nameCallback = new NameCallback("Name: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        try {
            callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception e) {
            throw new LoginException("Unable to retrieve name/password through callback handler: " + e.getMessage());
        }
        map.put(SHARED_NAME, nameCallback.getName());
        map.put(SHARED_PASSWORD, passwordCallback.getPassword());
        passwordCallback.clearPassword();
        return map;
    }

    protected void eraseCredentials(Map potentialState) {
        char[] pass;
        if (potentialState != null && (pass = (char[])potentialState.get(SHARED_PASSWORD)) != null) {
            Arrays.fill(pass, ' ');
        }
    }

    protected void preInitialise(Map moduleOptions) {
    }

    public static Principal createPrincipal(String principalClassName, String name) throws LoginException {
        try {
            Class<?> principalClass = Thread.currentThread().getContextClassLoader().loadClass(principalClassName);
            Constructor<?> ctor = principalClass.getConstructor(String.class);
            return (Principal)ctor.newInstance(name);
        }
        catch (Exception e) {
            throw new LoginException("Unable to instantiate principal class " + principalClassName + ": " + e.getMessage());
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map moduleOptions) {
        this.log.debug((Object)"Initialise");
        HashMap moduleOptionsCopy = new HashMap(moduleOptions);
        this.preInitialise(moduleOptionsCopy);
        this.authState = new AuthState(subject, callbackHandler, sharedState, new ModuleOptions(moduleOptionsCopy));
    }

    @Override
    public boolean abort() throws LoginException {
        this.log.debug((Object)"Abort");
        if (this.authState != null) {
            boolean abort = this.authState.abort();
            this.authState = null;
            return abort;
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        this.log.debug((Object)"commit");
        if (this.authState == null) {
            throw new LoginException("IllegalState for commit - authState is null");
        }
        return this.authState.commit();
    }

    @Override
    public boolean login() throws LoginException {
        this.log.debug((Object)"login");
        if (this.authState == null) {
            throw new LoginException("IllegalState for login - authState is null");
        }
        return this.authState.login();
    }

    @Override
    public boolean logout() throws LoginException {
        this.log.debug((Object)"logout");
        if (this.authState == null) {
            return true;
        }
        boolean logout = this.authState.logout();
        this.authState = null;
        return logout;
    }

    class ModuleOptions {
        private final boolean tryFirstPass;
        private final boolean useFirstPass;
        private final boolean storePass;
        private final boolean clearPass;

        public ModuleOptions(Map moduleOptions) {
            this.tryFirstPass = "true".equalsIgnoreCase((String)moduleOptions.get("tryFirstPass"));
            this.useFirstPass = "true".equalsIgnoreCase((String)moduleOptions.get("useFirstPass"));
            this.storePass = "true".equalsIgnoreCase((String)moduleOptions.get("storePass"));
            this.clearPass = "true".equalsIgnoreCase((String)moduleOptions.get("clearPass"));
        }

        public boolean isUseShared() {
            return this.tryFirstPass || this.useFirstPass;
        }

        public boolean isUseCallback() {
            return !this.useFirstPass;
        }

        public boolean isStorePass() {
            return this.storePass;
        }

        public boolean isClearPass() {
            return this.clearPass;
        }
    }

    class AuthState {
        private final ModuleOptions options;
        private final Map sharedState;
        private final Subject subject;
        private final CallbackHandler callbackHandler;
        private boolean loginSucceeded = false;
        private boolean commitSucceeded = false;
        private final Set authenticatedPrincipals = new HashSet();
        private final Set alreadyExistingPrincipals = new HashSet();

        public AuthState(Subject subject, CallbackHandler callbackHandler, Map sharedState, ModuleOptions moduleOptions) {
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = sharedState;
            this.options = moduleOptions;
        }

        public boolean login() throws LoginException {
            boolean loginSucceeded = false;
            LoginException lastLoginException = null;
            Set principals = null;
            Map potentialState = null;
            if (this.options.isUseShared()) {
                try {
                    potentialState = AbstractLoginModule.this.getCredentials(this.sharedState);
                    principals = AbstractLoginModule.this.authenticate(potentialState);
                    loginSucceeded = true;
                }
                catch (LoginException e) {
                    lastLoginException = e;
                    AbstractLoginModule.this.eraseCredentials(potentialState);
                }
            }
            if (!loginSucceeded && this.options.isUseCallback()) {
                if (this.callbackHandler == null) {
                    throw new LoginException("No callback handler passed in initialisation of login module");
                }
                potentialState = AbstractLoginModule.this.getCredentials(this.callbackHandler);
                try {
                    principals = AbstractLoginModule.this.authenticate(potentialState);
                    loginSucceeded = true;
                }
                catch (LoginException e) {
                    lastLoginException = e;
                    AbstractLoginModule.this.eraseCredentials(potentialState);
                }
            }
            if (!loginSucceeded) {
                if (lastLoginException != null) {
                    throw lastLoginException;
                }
                throw new LoginException("Login failed");
            }
            if (principals != null) {
                this.authenticatedPrincipals.addAll(principals);
            }
            if (this.options.isStorePass()) {
                this.sharedState.putAll(potentialState);
            } else {
                AbstractLoginModule.this.eraseCredentials(potentialState);
            }
            this.loginSucceeded = true;
            return true;
        }

        public boolean commit() throws LoginException {
            if (!this.loginSucceeded) {
                return false;
            }
            if (this.authenticatedPrincipals == null) {
                throw new LoginException("Illegal state - login succeeded but no identiy set");
            }
            Set<Principal> principals = this.subject.getPrincipals();
            if (this.authenticatedPrincipals != null) {
                for (Principal principal : this.authenticatedPrincipals) {
                    if (principals.add(principal)) continue;
                    this.alreadyExistingPrincipals.add(principal);
                }
            }
            this.commitSucceeded = true;
            if (this.options.isClearPass()) {
                this.removeSharedState();
            }
            return true;
        }

        public boolean logout() throws LoginException {
            if (!this.commitSucceeded) {
                return true;
            }
            if (this.options.isStorePass()) {
                this.removeSharedState();
            }
            Set<Principal> principals = this.subject.getPrincipals();
            try {
                if (this.authenticatedPrincipals != null) {
                    for (Principal principal : this.authenticatedPrincipals) {
                        this.destroyAndRemove(principals, principal, this.subject.isReadOnly());
                    }
                }
            }
            catch (DestroyFailedException e) {
                throw new LoginException(e.getMessage());
            }
            return true;
        }

        private void destroyAndRemove(Set principals, Principal principal, boolean isReadOnly) throws DestroyFailedException, LoginException {
            if (this.alreadyExistingPrincipals.contains(principal)) {
                return;
            }
            if (principal instanceof Destroyable) {
                ((Destroyable)((Object)principal)).destroy();
            } else if (isReadOnly) {
                throw new LoginException(principal.getClass() + " not Destroyable and subject is read only");
            }
            if (!isReadOnly) {
                principals.remove(principal);
            }
        }

        public boolean abort() throws LoginException {
            if (!this.loginSucceeded) {
                return false;
            }
            if (this.loginSucceeded && this.commitSucceeded) {
                return this.logout();
            }
            if (this.options.isStorePass()) {
                this.removeSharedState();
            }
            return true;
        }

        private void removeSharedState() {
            this.sharedState.remove(AbstractLoginModule.SHARED_NAME);
            char[] pass = (char[])this.sharedState.remove(AbstractLoginModule.SHARED_PASSWORD);
            if (pass != null) {
                Arrays.fill(pass, ' ');
            }
        }
    }
}

