/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.apache.httpd.ci;

import java.util.Collections;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.HttpdServer;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.apache.httpd.step.ApacheVirtualHostDefinition;

@SuppressWarnings("serial")
@ConfigurationItem(description = "A standard Apache 2 installation.", category = "middleware")
public class ApacheHttpdServer extends HttpdServer {

	@ConfigurationItemProperty(required = true, label = "Apache Control Path", description = "The path of the executable that will restart apache. Valid examples; /usr/sbin/apachectl")
	private String apachectlPath;

	@ConfigurationItemProperty(required = true, description = "The location where deployit will generate apache httpd.conf fragment files.")
	private String configurationLocation;

	@ConfigurationItemProperty(required = true, label = " Ht Docs Location", description = "The location where deployit will create a directory (based on the vhost name) where static content will be placed.")
	private String htdocsLocation;

	@ConfigurationItemProperty(required = true, description = "The location where deployit will create a directory where access log will be placed.")
	private String accessLogLocation;

	@ConfigurationItemProperty(required = true, description = "The location where deployit will create a directory where error log will be placed.")
	private String errorLogLocation;

	public HostSession connectToAdminHost() {
		return HostSessionFactory.getHostSession(host);
	}
	
	public ApacheVirtualHostDefinition getVhostDefinition(String virtualHost) {
		return new ApacheVirtualHostDefinition(virtualHost, htdocsLocation,
				host.getOperatingSystemFamily(), Collections.singleton(this));
	}

	public String getConfFilePathForVirtualHost(String virtualHost) {
		StringBuilder confFilePath = new StringBuilder();
		confFilePath.append(getConfigurationLocation());
		confFilePath.append(getHost().getFileSeparator());
		confFilePath.append(getVhostDefinition(virtualHost).getFileName());
		return confFilePath.toString();
	}

	public String getHtdocsDirPathForVirtualHost(String virtualHost) {
		return getVhostDefinition(virtualHost).getDocumentRoot();
	}

	public String getApachectlPath() {
		return apachectlPath;
	}

	public void setApachectlPath(String apachectlPath) {
		this.apachectlPath = apachectlPath;
	}

	public String getConfigurationLocation() {
		return configurationLocation;
	}

	public void setConfigurationLocation(String configurationLocation) {
		this.configurationLocation = configurationLocation;
	}

	public String getHtdocsLocation() {
		return htdocsLocation;
	}

	public void setHtdocsLocation(String htdocsLocation) {
		this.htdocsLocation = htdocsLocation;
	}

	public String getAccessLogLocation() {
		return accessLogLocation;
	}

	public void setAccessLogLocation(String accessLogLocation) {
		this.accessLogLocation = accessLogLocation;
	}

	public String getErrorLogLocation() {
		return errorLogLocation;
	}

	public void setErrorLogLocation(String errorLogLocation) {
		this.errorLogLocation = errorLogLocation;
	}

}
