/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.InternalHistoryProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.Revision;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.HistoryService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.comparison.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class HistoryResource
implements InternalHistoryProxy {
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Comparator comparator;

    public List<Revision> readRevisions(String id) {
        this.checkId(id);
        List versionRevisions = this.historyService.getVersionRevisions(id);
        return versionRevisions.stream().map(r -> new Revision(r.getRevisionId(), r.getCreatedAt(), r.getUsername())).collect(Collectors.toList());
    }

    public ConfigurationItem readRevision(String id, String revisionName) {
        this.checkId(id);
        return this._readRevision(id, revisionName);
    }

    public Comparison compare(String id, List<String> revisionNames) {
        this.checkId(id);
        Checks.checkArgument((revisionNames.size() > 1 ? 1 : 0) != 0, (String)"Need two revisions to compare.", (Object[])new Object[0]);
        String firstRevision = revisionNames.get(0);
        ConfigurationItem configurationItem = this._readRevision(id, firstRevision);
        Map multimap = this.comparator.compare(configurationItem, revisionNames.stream().skip(1L).map(r -> this._readRevision(id, (String)r)).collect(Collectors.toList()));
        return Comparison.from((Map)multimap);
    }

    private ConfigurationItem _readRevision(String id, String revisionName) {
        if (revisionName.equals("current")) {
            return this.repositoryService.read(id);
        }
        return this.historyService.readRevision(id, revisionName);
    }

    private void checkId(String id) {
        Checks.checkNotNull((Object)id, (String)"id");
        if (!this.repositoryService.exists(id)) {
            throw new Checks.IncorrectArgumentException("The id [%s] does not exist.", new Object[]{id});
        }
    }
}

