/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DownloadService;
import com.xebialabs.deployit.core.rest.api.DownloadResource$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015v!\u0002\r\u001a\u0011\u00031c!\u0002\u0015\u001a\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007y\u0005\u0001\u000b\u0011\u0002\u001b\u0007\t!J\u0002!\u0010\u0005\t#\u0016\u0011\t\u0011)A\u0005%\")\u0001'\u0002C\u0001[\"9Q/\u0002b\u0001\n\u00131\bBB?\u0006A\u0003%q\u000fC\u0004\u007f\u000b\t\u0007I\u0011\u0002<\t\r},\u0001\u0015!\u0003x\u0011\u001d\t\t!\u0002C!\u0003\u0007Aq!!\f\u0006\t\u0003\ty\u0003C\u0004\u0002:\u0015!I!a\u000f\t\u000f\u00055S\u0001\"\u0003\u0002P!9\u0011QK\u0003\u0005\n\u0005]cABA.\u000b\u0015\ti\u0006C\u0005\u00024E\u0011\t\u0011)A\u0005o\"1\u0001'\u0005C\u0001\u0003?Bq!a\u001a\u0012\t\u0003\tI\u0007C\u0004\u0002\u0002F!\t!a!\t\u000f\u0005%\u0015\u0003\"\u0001\u0002\f\"I\u0011\u0011S\u0003\u0002\u0002\u0013-\u00111S\u0001\u0011\t><h\u000e\\8bIJ+7o\\;sG\u0016T!AG\u000e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001d;\u0005!!/Z:u\u0015\tqr$\u0001\u0003d_J,'B\u0001\u0011\"\u0003!!W\r\u001d7ps&$(B\u0001\u0012$\u0003%AXMY5bY\u0006\u00147OC\u0001%\u0003\r\u0019w.\\\u0002\u0001!\t9\u0013!D\u0001\u001a\u0005A!un\u001e8m_\u0006$'+Z:pkJ\u001cWm\u0005\u0002\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0014\u00021\r{e\nV#O)~#\u0016\fU#T?\u001a{E\nR#S\u001d\u0006kU)F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003mC:<'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aa\u0015;sS:<\u0017!G\"P\u001dR+e\nV0U3B+5k\u0018$P\u0019\u0012+%KT!N\u000b\u0002\u001aB!\u0002 E\u0013B\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iG\u0001\bg\u0016\u001cWO]3e\u0013\t\u0019\u0005IA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011QiR\u0007\u0002\r*\u0011!$H\u0005\u0003\u0011\u001a\u0013q\u0002R8x]2|\u0017\rZ*feZL7-\u001a\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bQa\u001d7gi)T\u0011AT\u0001\tOJL'P\u001f7fI&\u0011\u0001k\u0013\u0002\b\u0019><w-\u001b8h\u00039)\u0007\u0010]8siJ{w\u000e\u001e)bi\"\u0004\"a\u0015.\u000f\u0005QC\u0006CA+-\u001b\u00051&BA,&\u0003\u0019a$o\\8u}%\u0011\u0011\fL\u0001\u0007!J,G-\u001a4\n\u0005mZ&BA--Q\u00111Ql\u001b7\u0011\u0005yKW\"A0\u000b\u0005\u0001\f\u0017AC1o]>$\u0018\r^5p]*\u0011!mY\u0001\bM\u0006\u001cGo\u001c:z\u0015\t!W-A\u0003cK\u0006t7O\u0003\u0002gO\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001i\u0003\ry'oZ\u0005\u0003U~\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003E#\"A\\8\u0011\u0005\u001d*\u0001\"B)\b\u0001\u0004\u0011\u0006\u0006B8^W2D#a\u0002:\u0011\u0005y\u001b\u0018B\u0001;`\u0005%\tU\u000f^8xSJ,G-\u0001\u0006fqB|'\u000f\u001e*p_R,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003ub\n!![8\n\u0005qL(\u0001\u0002$jY\u0016\f1\"\u001a=q_J$(k\\8uA\u0005\u00012m\u001c8uK:$H+\u001f9fgJ+\u0007o\\\u0001\u0012G>tG/\u001a8u)f\u0004Xm\u001d*fa>\u0004\u0013\u0001\u00033po:dw.\u00193\u0015\t\u0005\u0015\u00111\u0004\t\u0005\u0003\u000f\t9\"\u0004\u0002\u0002\n)\u0019a$a\u0003\u000b\t\u00055\u0011qB\u0001\u0003eNTA!!\u0005\u0002\u0014\u0005\u0011qo\u001d\u0006\u0003\u0003+\tqA[1lCJ$\u0018-\u0003\u0003\u0002\u001a\u0005%!\u0001\u0003*fgB|gn]3\t\r\u0005uA\u00021\u0001S\u0003-!wn\u001e8m_\u0006$7*Z=)\u000f\u0005m\u0011\u0011E6\u0002*A!\u00111EA\u0013\u001b\t\tY!\u0003\u0003\u0002(\u0005-!!\u0003)bi\"\u0004\u0016M]1nC\t\tY#A\u0006e_^tGn\\1eW\u0016L\u0018\u0001\u0003:fO&\u001cH/\u001a:\u0015\u000bI\u000b\t$!\u000e\t\r\u0005MR\u00021\u0001x\u0003\u00111\u0017\u000e\\3\t\r\u0005]R\u00021\u0001S\u0003-\u0019wN\u001c;f]R$\u0016\u0010]3\u0002#\u0011|wO\u001c7pC\u00124u\u000e\u001c3fe\u001a{'\u000f\u0006\u0003\u0002>\u0005-\u0003\u0003BA \u0003\u000fj!!!\u0011\u000b\t\u0005M\u00121\t\u0006\u0004\u0003\u000bB\u0014a\u00018j_&!\u0011\u0011JA!\u0005\u0011\u0001\u0016\r\u001e5\t\r\u0005ua\u00021\u0001S\u0003M\u0011XmZ5ti\u0016\u00148i\u001c8uK:$H+\u001f9f)\u0019\ti$!\u0015\u0002T!1\u0011QD\bA\u0002ICa!a\u000e\u0010\u0001\u0004\u0011\u0016AD2p]R,g\u000e\u001e+za\u00164uN\u001d\u000b\u0005\u0003{\tI\u0006\u0003\u0004\u0002\u001eA\u0001\rA\u0015\u0002\n\r&dW-\u0016;jYN\u001c\"!\u0005\u0016\u0015\t\u0005\u0005\u0014Q\r\t\u0004\u0003G\nR\"A\u0003\t\r\u0005M2\u00031\u0001x\u0003E!xn\u0015;sK\u0006l\u0017N\\4PkR\u0004X\u000f\u001e\u000b\u0005\u0003W\n\t\b\u0005\u0003\u0002\b\u00055\u0014\u0002BA8\u0003\u0013\u0011qb\u0015;sK\u0006l\u0017N\\4PkR\u0004X\u000f\u001e\u0005\t\u0003g\"B\u00111\u0001\u0002v\u0005ia-\u001b8bY&TXm\u0016:ji\u0016\u0004RaKA<\u0003wJ1!!\u001f-\u0005!a$-\u001f8b[\u0016t\u0004cA\u0016\u0002~%\u0019\u0011q\u0010\u0017\u0003\tUs\u0017\u000e^\u0001\u0007[>4X\rV8\u0015\t\u0005u\u0012Q\u0011\u0005\b\u0003\u000f+\u0002\u0019AA\u001f\u0003E!Wm\u001d;j]\u0006$\u0018n\u001c8G_2$WM]\u0001\u000eK:\u001cXO]3Qe\u0016\u001cXM\u001c;\u0015\u0007]\fi\t\u0003\u0004\u0002\u0010Z\u0001\rAU\u0001\u0007_J,En]3\u0002\u0013\u0019KG.Z+uS2\u001cH\u0003BA1\u0003+Ca!a\r\u0018\u0001\u00049\bfA\u0003\u0002\u001aB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \u0016\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\u0019+!(\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class DownloadResource
extends AbstractSecuredResource
implements DownloadService,
Logging {
    private final File exportRoot;
    private final File contentTypesRepo;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String CONTENT_TYPES_FOLDERNAME() {
        return DownloadResource$.MODULE$.CONTENT_TYPES_FOLDERNAME();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DownloadResource downloadResource = this;
        synchronized (downloadResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private File exportRoot() {
        return this.exportRoot;
    }

    private File contentTypesRepo() {
        return this.contentTypesRepo;
    }

    public Response download(@PathParam(value="downloadkey") String downloadKey) {
        File downloadFolder = this.downloadFolderFor(downloadKey).toFile();
        File contents = (File)Try$.MODULE$.apply((Function0 & Serializable)() -> (File)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])downloadFolder.listFiles()))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("The download with key [" + downloadKey + "] was not found.", new Object[0]);
        });
        String contentType = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> (String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.contentTypeFor(downloadKey))).asScala().head()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Cannot determine content type for download with key [" + downloadKey + "]", new Object[0]);
        });
        StreamingOutput output = this.FileUtils(contents).toStreamingOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            LocalFile.from((File)downloadFolder).deleteRecursively();
            this.contentTypeFor(downloadKey).toFile().delete();
        });
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Going to stream download of [" + downloadKey + "] with type [" + contentType + "]");
        return Response.ok((Object)output, (String)contentType).header("Content-Disposition", (Object)("attachment; filename=\"" + contents.getName() + "\"")).header("Content-Length", (Object)String.valueOf(contents.length())).build();
    }

    public String register(File file, String contentType) {
        String downloadKey = UUID.randomUUID().toString();
        Path downloadFolder = this.downloadFolderFor(downloadKey);
        if (!downloadFolder.toFile().mkdirs()) {
            throw new DeployitException("Cannot create directory for download: " + downloadFolder);
        }
        Path movedFile = this.FileUtils(file).moveTo(downloadFolder);
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Registering download [" + movedFile + "] with content type [" + contentType + "] and key [" + downloadKey + "]");
        this.registerContentType(downloadKey, contentType);
        return downloadKey;
    }

    private Path downloadFolderFor(String downloadKey) {
        return Paths.get(this.exportRoot().getAbsolutePath(), downloadKey);
    }

    private Path registerContentType(String downloadKey, String contentType) {
        Path path;
        Path registerPath = this.contentTypeFor(downloadKey);
        try {
            path = Files.write(registerPath, Collections.singletonList(contentType), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e, "Cannot register content type for download key [" + downloadKey + "] in [" + registerPath + "]", new Object[0]);
        }
        return path;
    }

    private Path contentTypeFor(String downloadKey) {
        return Paths.get(this.contentTypesRepo().getAbsolutePath(), downloadKey);
    }

    private FileUtils FileUtils(File file) {
        return new FileUtils(this, file);
    }

    @Autowired
    public DownloadResource(@Qualifier(value="exportRootPath") String exportRootPath) {
        Logging.$init$((Logging)this);
        this.exportRoot = this.FileUtils(new File(exportRootPath)).ensurePresent("Cannot create download cache at " + exportRootPath);
        this.contentTypesRepo = this.FileUtils(new File(this.exportRoot(), DownloadResource$.MODULE$.CONTENT_TYPES_FOLDERNAME())).ensurePresent("Cannot create content-type repository under " + this.exportRoot().getAbsolutePath());
    }

    private class FileUtils {
        private final File file;
        public final /* synthetic */ DownloadResource $outer;

        public StreamingOutput toStreamingOutput(Function0<BoxedUnit> finalizeWrite) {
            return outputStream -> {
                FileInputStream is = new FileInputStream($this.file);
                try {
                    OverthereUtils.write((InputStream)is, (OutputStream)outputStream);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    finalizeWrite.apply$mcV$sp();
                }
            };
        }

        public Path moveTo(Path destinationFolder) {
            Path path;
            Path destination = destinationFolder.resolve(this.file.getName());
            try {
                path = Files.move(this.file.toPath(), destination, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new DeployitException((Throwable)e, "Could not move file " + this.file.getAbsolutePath() + " to download cache [" + destination + "]", new Object[0]);
            }
            return path;
        }

        public File ensurePresent(String orElse) {
            if (this.file.exists() || this.file.mkdirs()) {
                return this.file;
            }
            throw new DeployitException(orElse);
        }

        public /* synthetic */ DownloadResource com$xebialabs$deployit$core$rest$api$DownloadResource$FileUtils$$$outer() {
            return this.$outer;
        }

        public FileUtils(DownloadResource $outer, File file) {
            this.file = file;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

