/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api;

import java.util.List;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import org.jboss.resteasy.annotations.providers.jaxb.Wrapped;

import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.Revision;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

@Path("/internal/history")
@Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
public interface InternalHistoryProxy {

    @GET
    @Path("revisions/{ID:.+}")
    @Wrapped(element = "list")
    List<Revision> readRevisions(@PathParam("ID") String id);

    @GET
    @Path("compare/{ID:.+}")
    public Comparison compare(@PathParam("ID") final String id, @QueryParam("revision") final List<String> revisionNames);

    @GET
    @Path("ci/{ID:.+}")
    ConfigurationItem readRevision(@PathParam("ID") String id, @QueryParam("revision") String revisionName);
}
