/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@XmlRootElement
public class Comparison extends AbstractDTO {

    private List<ComparisonLine> lines = new ArrayList<>();

    public static Comparison from(Map<String, List<String>> multimap) {
        Comparison c = new Comparison();
        for (String key : multimap.keySet()) {
        	List<String> values = multimap.get(key);
            c.addLine(key, values);
        }
        return c;
    }

    private void addLine(String key, List<String> values) {
        lines.add(new ComparisonLine(key, values.get(0), values.subList(1, values.size())));
    }

    @XmlElement
    public List<ComparisonLine> getLines() {
        return lines;
    }

    public void setLines(final List<ComparisonLine> lines) {
        this.lines = lines;
    }

    public static class ComparisonLine extends AbstractDTO {
        private String key;

        private String referenceValue;

        private List<String> values;

        public ComparisonLine() {
        }

        public ComparisonLine(final String key, final String referenceValue, final List<String> values) {
            this.key = key;
            this.referenceValue = referenceValue;
            this.values = values;
        }

        @XmlElement
        public String getKey() {
            return key;
        }

        public void setKey(final String key) {
            this.key = key;
        }

        @XmlElement
        public String getReferenceValue() {
            return referenceValue;
        }

        public void setReferenceValue(final String referenceValue) {
            this.referenceValue = referenceValue;
        }

        @XmlElement
        public List<String> getValues() {
            return values;
        }

        public void setValues(final List<String> values) {
            this.values = values;
        }
    }
}
