/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.jaxb;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement(name = "item")
@XmlSeeAlso( { CollectionOfStringsMapElement.class, MapMapElement.class, MapMapElement.MapEntry.class })
public final class MapElement {

    private String key;

    private Object value;

    public MapElement() {

    }

    public MapElement(final String key, final Object value) {
        this.key = key;
        this.value = value;
    }

    public void setKey(final String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(final Object value) {
        this.value = value;
    }

}
