/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.dto;

import java.lang.String;
import java.util.Calendar;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Revision {
    
    private String revisionName;
    
    private Calendar createdAt;

    private String username;

    public Revision(final String revisionName, final Calendar createdAt, final String username) {
        this.revisionName = revisionName;
        this.createdAt = createdAt;
        this.username = username;
    }

    public Revision() {
    }

    @XmlElement
    public String getRevisionName() {
        return revisionName;
    }

    @XmlElement
    public Calendar getCreatedAt() {
        return createdAt;
    }

    @XmlElement
    public String getUsername() {
        return username;
    }

    public void setUsername(final String username) {
        this.username = username;
    }

    public void setRevisionName(final String revisionName) {
        this.revisionName = revisionName;
    }

    public void setCreatedAt(final Calendar createdAt) {
        this.createdAt = createdAt;
    }
}
