package com.xebialabs.xlplatform.artifact

import java.io.{BufferedInputStream, BufferedOutputStream}

import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.overthere.local.LocalFile
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry
import com.xebialabs.xlplatform.utils.ResourceManagement._

object ExternalArtifactDownloader {

  def downloadResolvedFile(artifact: SourceArtifact, workDir: WorkDir): LocalFile = {
    using(ArtifactResolverRegistry.resolve(artifact)) { resolved =>
      using(new BufferedInputStream(resolved.openStream())) { in =>
        val file = workDir.newFile(resolved.getFileName)
        using(new BufferedOutputStream(file.getOutputStream)) { out =>
          val buffer = new Array[Byte](16 * 1024)
          Iterator.continually(in read buffer) takeWhile (_ != -1) foreach { r =>
            out write(buffer, 0, r)
          }
        }
        file
      }

    }
  }

}
