/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ServerConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class ServerConfigFile {
    private final File configFile;
    private static final Logger logger = LoggerFactory.getLogger(ServerConfigFile.class);

    public ServerConfigFile(File file) {
        this.configFile = file;
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public String getName() {
        return this.configFile.getName();
    }

    public void readIntoConfiguration(ServerConfiguration serverConfiguration) {
        serverConfiguration.load(ServerConfigFile.readConfigurationFile(this.configFile));
    }

    public ServerConfiguration loadConfig() {
        return this.loadConfig(true, true);
    }

    public ServerConfiguration loadConfig(boolean saveDirty, boolean encryptedPasswords) {
        if (this.configFile.exists()) {
            ServerConfiguration serverConfiguration = ServerConfigFile.readConfiguration(this.configFile, encryptedPasswords);
            if (!serverConfiguration.isValid()) {
                throw new Error("Configuration " + this.configFile + " is not valid please run with -setup option.");
            }
            if (saveDirty) {
                this.saveDirtyConfiguration(serverConfiguration);
            }
            return serverConfiguration;
        }
        throw new Error("Configuration " + this.configFile + " does not exist, please run with -setup option before starting the server or command line interface.");
    }

    static ServerConfiguration readConfiguration(File configFile, boolean encryptedPasswords) {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setFile(configFile);
        serverConfiguration.setConfigResource((Resource)new ClassPathResource(configFile.getName()));
        serverConfiguration.load(ServerConfigFile.readConfigurationFile(configFile), encryptedPasswords);
        return serverConfiguration;
    }

    static Properties readConfigurationFile(File configFile) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public void writeConfiguration(ServerConfiguration serverConfiguration) {
        Properties properties = new Properties();
        serverConfiguration.save(properties);
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.configFile));){
            String comment = "XL Deploy configuration file.\n\nNotes: \n * If you modify this file, you must restart the XL Deploy server.\n * Use `repository.keystore.password` property to specify the password used to open the repository keystore file, \n   which contains the encryption key for the rest of the passwords.\n * The other passwords specified in this file are normally encrypted, but you can change their value using plaintext \n   and at the next start of the server the modified passwords will be re-encrypted.\n";
            properties.store(output, comment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveDirtyConfiguration(ServerConfiguration serverConfiguration) {
        if (serverConfiguration.isDirty()) {
            logger.info("Saving (dirty) configuration");
            this.writeConfiguration(serverConfiguration);
        }
    }

    public String toString() {
        return this.configFile.getAbsolutePath();
    }
}

