package com.xebialabs.deployit.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.deployit.upgrade.PlatformUpgradeConstants.{CENTRAL_CONFIG,UpgraderCallbackFn}
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService

import java.util

class PlatformUpgrade(val upgradeStrategy: UpgradeStrategy,
                      val forceUpgrades: Boolean,
                      val repositoryVersionService: RepositoryVersionService,
                      val centralConfigVersion: CentralConfigVersion,
                      callback: UpgraderCallbackFn)
  extends Upgrader(upgradeStrategy, forceUpgrades, repositoryVersionService) {

  override def getComponentVersion(component: String): Version = {
    if (component == CENTRAL_CONFIG) {
      val version = centralConfigVersion.getCentralConfigurationVersion
      return Version.valueOf(CENTRAL_CONFIG, version)
    }
    super.getComponentVersion(component)
  }

  override protected def updateVersion(version: Version, upgrades: util.List[Upgrade]): Unit = {
    if (version.getComponent == CENTRAL_CONFIG) {
      upgradeStrategy.doUpgrades(upgrades)
      centralConfigVersion.updateCentralConfigurationVersion(version.getVersion)
      callback()
    } else {
      super.updateVersion(version, upgrades)
    }
  }
}

object PlatformUpgradeConstants {
  val CENTRAL_CONFIG: String = "central-config"

  type UpgraderCallbackFn = () => Unit
}