package com.xebialabs.deployit.core.defaults

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.jdk.CollectionConverters._

class CiDefaultEntityPropertiesProcessor(defaultEntityResolvers: Map[Type, DefaultEntityResolver[_ <: ConfigurationItem]]) {

  def fillDefaultEntities(ciItem: ConfigurationItem): Unit = {
    getDefaultEntitiesForCi(ciItem)
      .map { case (name, resolver) => (name, resolver.resolveDefaultValue) }
      .collect { case (name, Some(ci)) => (name, ci) }
      .foreach { case (name, ci) => ciItem.setProperty(name, ci) }
  }

  private def getDefaultEntitiesForCi(ciItem: ConfigurationItem): Map[String, DefaultEntityResolver[_ <: ConfigurationItem]] = {
    ciItem
      .getType
      .getDescriptor
      .getPropertyDescriptors
      .asScala
      .filter(propertyDescriptor => propertyDescriptor.getReferencedType != null && defaultEntityResolvers.keys.toSet.contains(propertyDescriptor.getReferencedType))
      .map(propertyDescriptor => (propertyDescriptor.getName, defaultEntityResolvers(propertyDescriptor.getReferencedType)))
      .toMap
  }

}

