package com.xebialabs.deployit.util;

import java.io.File;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;


public final class DeployitKeys {

    public static final SecretKey DEFAULT_PASSWORD_ENCRYPTION_KEY =  new SecretKeySpec(new byte[]{
            (byte) 0xe3, (byte) 0xea, 0x16, (byte) 0xaf, (byte) 0x94, 0x5f, 0x5b, 0x17,
            0x2e, (byte) 0xe6, 0x31, (byte) 0xd3, (byte) 0xc0, 0x70, 0x27, (byte) 0xd6
        }, "AES");

    public static SecretKey getPasswordEncryptionKey(String keystorePassword) {
        if (DeployitKeyStore.getFile(new File("conf")).exists()) {
            DeployitKeyStore.load(keystorePassword == null ? new char[0] : keystorePassword.toCharArray());
            return DeployitKeyStore.getPasswordEncryptionKey();
        } else {
            return DEFAULT_PASSWORD_ENCRYPTION_KEY;
        }
    }

}
