package com.xebialabs.deployit.spring;

import org.springframework.core.env.PropertySource;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;

public class HoconConfigPropertySource extends PropertySource<Config> {
    public HoconConfigPropertySource(String name, Config source) {
        super(name, source);
    }

    @Override
    public Object getProperty(String path) {
        try {
            return source.hasPath(path) ? source.getAnyRef(path) : null;
        } catch (ConfigException.BadPath e) {
            return null;
        }
    }
}
