package com.xebialabs.deployit.log;

import ch.qos.logback.classic.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

import java.util.logging.Level;
import java.util.logging.LogManager;

public final class LogbackHelper {

    private LogbackHelper() {
    }

    private static final Logger logger = LoggerFactory.getLogger(LogbackHelper.class);

    public static void disableConsoleLoggerIfNeeded(final String consoleAppenderName) {
        LoggerContext lc = (LoggerContext) LoggerFactory.getILoggerFactory();
        final ch.qos.logback.classic.Logger root = lc.getLogger(Logger.ROOT_LOGGER_NAME);
        if (isServiceMode()) {
            if (root.getAppender(consoleAppenderName) != null) {
                root.info("Removing console log appender from root logger. Please search for other log entries in the application log file");
                root.detachAppender(consoleAppenderName);
            } else {
                logger.warn("{} appender not found. Cannot disable it to avoid console log pollution", consoleAppenderName);
            }
        }
    }

    /**
     * Before using jul to slf4j bridge read about <a href="http://logback.qos.ch/manual/configuration.html#LevelChangePropagator">LevelChangePropagator</a>
     */
    public static void enableJavaUtilLoggingBridge() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getGlobal().setLevel(Level.FINEST);
    }

    private static boolean isServiceMode() {
        return System.console() == null;
    }
}
