package com.xebialabs.deployit.audit;

import com.thoughtworks.xstream.XStream;
import com.xebialabs.deployit.core.xml.PasswordMaskingXStreamCiConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemCollectionConverter;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemMarshallingStrategy;

public class CiFormatter {

    private final XStream xStream;

    public CiFormatter() {
        xStream = new XStream();
        xStream.registerConverter(new PasswordMaskingXStreamCiConverter());
        xStream.registerConverter(new ConfigurationItemCollectionConverter(xStream.getMapper()));
        xStream.setMarshallingStrategy(new ConfigurationItemMarshallingStrategy(XStream.XPATH_RELATIVE_REFERENCES));
    }

    public String format(ConfigurationItem ci) {
        return xStream.toXML(ci);
    }
}
