/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.SessionCookieConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCookieSetupListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionCookieSetupListener.class);
    private final String sessionCookieName;
    private final String cookieDomain;
    private final boolean secureCookie;
    private final boolean httpOnly;
    private int maxAgeInSeconds;

    public SessionCookieSetupListener(String sessionCookieName, String cookieDomain, boolean secureCookie, boolean httpOnly, int maxAgeInSeconds) {
        this.sessionCookieName = sessionCookieName;
        this.cookieDomain = cookieDomain;
        this.secureCookie = secureCookie;
        this.httpOnly = httpOnly;
        this.maxAgeInSeconds = maxAgeInSeconds;
    }

    public SessionCookieSetupListener(String sessionCookieName, boolean secureCookie, boolean httpOnly, int maxAgeInSeconds) {
        this.sessionCookieName = sessionCookieName;
        this.cookieDomain = null;
        this.secureCookie = secureCookie;
        this.httpOnly = httpOnly;
        this.maxAgeInSeconds = maxAgeInSeconds;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        SessionCookieConfig scf = servletContext.getSessionCookieConfig();
        String cookiePath = this.determineCookiePath(servletContext);
        scf.setName(this.sessionCookieName);
        scf.setPath(cookiePath);
        if (this.cookieDomain != null) {
            scf.setDomain(this.cookieDomain);
        }
        scf.setSecure(this.secureCookie);
        scf.setHttpOnly(this.httpOnly);
        scf.setMaxAge(this.maxAgeInSeconds);
        LOG.info("Configuring session cookie: name={} path={} domain={} secure={} httpOnly={} maxAge={}", new Object[]{this.sessionCookieName, cookiePath, this.cookieDomain, this.secureCookie, this.httpOnly, this.maxAgeInSeconds});
    }

    protected String determineCookiePath(ServletContext servletContext) {
        String cookiePath = servletContext.getContextPath();
        if ("".equals(cookiePath)) {
            return "/";
        }
        return cookiePath;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

