package com.xebialabs.deployit.errors;

import com.xebialabs.deployit.HttpErrorHandler;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.stream.Collectors;

import static javax.servlet.http.HttpServletResponse.SC_PAYMENT_REQUIRED;

public class LicenseMissingErrorHandler implements HttpErrorHandler {

    private String licenseMissingPage = null;

    @Override
    public boolean canHandle(HttpServletRequest request, int code) {
        return code == SC_PAYMENT_REQUIRED;
    }

    @Override
    public void writeErrorContent(Writer writer) throws IOException {
        if (licenseMissingPage == null) {
            loadMissingLicensePageContents();
        }

        writer.write(licenseMissingPage);
    }

    private void loadMissingLicensePageContents() {
        try (InputStream inputStream = this.getClass().getResourceAsStream("error402page.html")) {
            licenseMissingPage = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining());
        } catch (IOException | NullPointerException ex) {
            useDefaultLicensePageContents();
        }
    }

    private void useDefaultLicensePageContents() {
        licenseMissingPage = "<html>\n" +
                "    <body>\n" +
                "    This Digital.ai Deploy server will not function due to a license problem. Either it could not be found,\n" +
                "    it was not properly readable, or it has expired. See the deployit log files for more information.\n" +
                "<br/><br/>\n" +
                "    If you would like to continue using Digital.ai Deploy, please contact your Digital.ai sales\n" +
                "    representative for a new license.\n" +
                "<br/><br/>\n" +
                "    Regards,<br/>\n" +
                "    the Digital.ai team\n" +
                "    </body>\n" +
                "</html>";
    }
}
