package com.xebialabs.deployit;

import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.core.rest.resteasy.UsernameInjectorPrePostProcessor;
import com.xebialabs.deployit.core.rest.resteasy.TemporaryFilesPrePostProcessorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class ClosingExceptionMapper<E extends Exception> implements ExceptionMapper<E> {

    public static final String X_EXCEPTION_TYPE = "X-Exception-Type";
    public static final String X_PATH = "X-Path";

    private static List<Runnable> cleanupActions = new ArrayList<>();

    protected final boolean hideInternals;

    protected ClosingExceptionMapper(boolean hideInternals) {
        this.hideInternals = hideInternals;
    }

    public static void registerCleanup(Runnable action) {
        cleanupActions.add(action);
    }

    @Override
    public final Response toResponse(E exception) {
        try {
            return handleException(exception);
        } finally {
            cleanupActions.forEach(Runnable::run);
            TemporaryFilesPrePostProcessorInterceptor.cleanup();
            PathInterceptor.cleanup();
            UsernameInjectorPrePostProcessor.cleanup();
        }
    }

    protected abstract Response handleException(E exception);

    protected Response checkWhetherWeHideInternals(int status, RuntimeException e, String content) {
        if (status > 499 && hideInternals) {
            UUID uuid = UUID.randomUUID();
            logger.error("[UUID={}] Encountered statuscode [{}], hiding it with a 400.", uuid, status);
            logger.error("[UUID={}] Exception: {}", uuid, e.getClass().getName());
            logger.error("[UUID={}] Error messages: {}", uuid, content);

            return Response.status(400).type(MediaType.TEXT_PLAIN).entity("An internal error has occurred, please notify your system administrator with the following code: " + uuid).build();
        }
        return null;
    }

    protected final Logger logger = LoggerFactory.getLogger(getClass());
}
