/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceContentServlet
extends DefaultServlet {
    private static final String FALLBACK_SYSTEM_PROPERTY_NAME = "com.xebialabs.deployit.jetty.ClassPathResourceContentServlet.fallbackDirectory";
    private final String packageName;
    private final boolean fallbackToDevelopmentResources;
    private final String fallbackDirectory;
    private static final Logger logger = LoggerFactory.getLogger(ClassPathResourceContentServlet.class);

    public ClassPathResourceContentServlet(String packageName) {
        Checks.checkNotNull((Object)packageName, (String)"packageName");
        this.packageName = packageName.replace('.', '/');
        this.fallbackDirectory = System.getProperty(FALLBACK_SYSTEM_PROPERTY_NAME);
        this.fallbackToDevelopmentResources = Strings.isNotEmpty((String)this.fallbackDirectory);
        if (logger.isDebugEnabled()) {
            logger.debug("Using {} as the document root on the classpath (fallbackToDevelopmentResources={}).", (Object)this.packageName, (Object)this.fallbackToDevelopmentResources);
        }
    }

    public Resource getResource(String pathInContext) {
        pathInContext = pathInContext.replace("-@project.version@", "");
        String resourcePath = this.packageName + pathInContext;
        if (logger.isDebugEnabled()) {
            logger.debug("Requested resource {} to load", (Object)resourcePath);
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        try {
            Resource r = null;
            URLResourceFactory resourceFactory = new URLResourceFactory();
            if (url != null) {
                r = Objects.equals(url.getProtocol(), "xlp") ? new XlpUrlResource(url) : resourceFactory.newResource(url);
            } else if (this.fallbackToDevelopmentResources) {
                String fallbackUrl = "file:" + this.fallbackDirectory + pathInContext;
                logger.info("Cannot find {} in classpath, falling back to URL {}", (Object)resourcePath, (Object)fallbackUrl);
                r = resourceFactory.newResource(fallbackUrl);
            }
            if (r == null || !r.exists()) {
                if (resourcePath.endsWith(".gz")) {
                    logger.debug("Cannot find {} in classpath", (Object)resourcePath);
                } else {
                    logger.error("Cannot find {} in classpath", (Object)resourcePath);
                }
            }
            return r;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static class XlpUrlResource
    extends Resource {
        private final Resource delegate;

        public XlpUrlResource(URL url) throws IOException {
            URLResourceFactory resourceFactory = new URLResourceFactory();
            try {
                this.delegate = resourceFactory.newResource(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public File getFile() throws IOException {
            return null;
        }

        public Path getPath() {
            return this.delegate.getPath();
        }

        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        public boolean isReadable() {
            return this.delegate.isReadable();
        }

        public URI getURI() {
            return this.delegate.getURI();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String getFileName() {
            return this.delegate.getFileName();
        }

        public Resource resolve(String s) {
            return this.delegate.resolve(s);
        }
    }
}

